package org.simantics.selectionview;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;

public class TypedVariableTabContribution implements TabContribution<Object> {

	final private Resource configuration;
	
	public TypedVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		this.configuration = configuration;
	}
	
	static class Contribution extends ModelledTabContributor {

		private String viewURI;
		
		public Contribution(String viewURI) {
			this.viewURI = viewURI;
		}
		
		@Override
		public void createControls(Composite body, IWorkbenchSite site) {

			try {

				final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, site);
				final SWTRoot root = loader.load(viewURI, runtime);
				root.createControls(body);
				body.addListener(SWT.Dispose, new Listener() {
					
					@Override
					public void handleEvent(Event event) {
						if(!loader.isDisposed())
							loader.dispose();
					}
					
				});
				
			} catch (DatabaseException e) {

				e.printStackTrace();
				Logger.defaultLogError(e);

			}

		}
		
	    @Override
	    public boolean equals(Object obj) {
	        if (this == obj)
	            return true;
	        else if (obj == null)
	            return false;
	        else if (!(obj instanceof Contribution))
	            return false;
	        Contribution c = (Contribution)obj;
	        return viewURI.equals(c.viewURI);
	    }
	    
	    @Override
	    public int hashCode() {
	    	return viewURI.hashCode();
	    }
		
	}
	

	@Override
	public boolean accept(ReadGraph graph, Object input) {
		return true;
//		return (input instanceof Variable);
	}
	
	private Variable getPossibleVariable(ReadGraph graph, Object input) throws DatabaseException {

		if(input instanceof Variable) {
			return (Variable)input;
		} else {
			return WorkbenchSelectionUtils.getPossibleVariable(graph, input);
		}
		
	}
	
	@Override
	public void contribute(ReadGraph graph, final Object object, Collection<ComparableTabContributor> result) throws DatabaseException {
		
		Variable variable = getPossibleVariable(graph, object);
		if(variable == null) return;
		
		Layer0 L0 = Layer0.getInstance(graph);
		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);
		Collection<Resource> types = graph.getObjects(configuration, SEL.TypedVariableTabContribution_HasType);
		if(types.isEmpty()) throw new DatabaseException("No type for " + graph.getPossibleURI(configuration));
		Resource view = graph.getPossibleObject(configuration, SEL.VariableTabContribution_HasView);
		if(view == null) {
			throw new DatabaseException("No view for " + graph.getPossibleURI(configuration));
		}
		Integer priority = graph.getPossibleRelatedValue(configuration, SEL.VariableTabContribution_HasPriority, Bindings.INTEGER);
		String label = graph.getPossibleRelatedValue(configuration, L0.HasLabel);
		final String viewURI = graph.getPossibleURI(view);

        Resource resource = variable.getPossibleRepresents(graph);
        if (resource == null)
            return;

        Collection<Resource> ts = graph.getTypes(resource);
        
        if (!Collections.disjoint(types, ts)) {

    		for(Resource r : graph.getObjects(configuration, SEL.VariableTabContribution_HasTest)) {
    			Boolean pass = Functions.exec(graph, r, graph, variable);
    			if(!pass) return;
    		}
    		
    		try {
    			Variable transformed = Simantics.tryInvokeSCL(graph, configuration, SEL.VariableTabContribution_transformation, variable);
    			if(transformed != null) variable = transformed;
    		} catch (DatabaseException e) {
    			// Errors are just ignored
    		}
        	
        	result.add(new ComparableTabContributor(new Contribution(viewURI), priority, variable, label));

        }

	}

}
