package org.simantics.selectionview;


public class CategoryNodeImpl implements CategoryNode {

	final private String name;
	final private String sortName;
	
	public CategoryNodeImpl(String name, String sortName) {
		assert(name != null);
		this.name = name;
		this.sortName = sortName != null ? sortName : name;
	}
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getSortingName() {
		return sortName;
	}
	
    @Override
    public int hashCode() {
        return name.hashCode();
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (CategoryNodeImpl.class != object.getClass())
            return false;
        CategoryNodeImpl r = (CategoryNodeImpl)object;
        return r.name.equals(name);
    }
	
}
