package org.simantics.selectionview;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

abstract public class AbstractTypedVariableTabContribution extends AbstractVariableTabContribution {

	public AbstractTypedVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		super(graph, configuration);
	}

	@Override
	public boolean accept(ReadGraph graph, Variable variable, Object selection) throws DatabaseException {

		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);

		Resource type = graph.getPossibleObject(configuration, SEL.AbstractTypedVariableTabContribution_HasType);
		if(type == null) throw new DatabaseException("No type for " + graph.getPossibleURI(configuration));

		Resource resource = variable.getPossibleRepresents(graph);
		if(resource == null) return false;
		
		if(!graph.isInstanceOf(resource, type)) return false;
		
		return super.accept(graph, variable, selection);
		
	}
	
}
