package org.simantics.selectionview;

import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

abstract public class AbstractResourceTabContribution implements TabContribution<Resource> {

	final protected Resource configuration;

	public AbstractResourceTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		this.configuration = configuration;
	}

	public abstract void getContributors(ReadGraph graph, Resource resource, Integer priority, String label, Collection<ComparableTabContributor> result) throws DatabaseException;
	
	@Override
	public boolean accept(ReadGraph graph, Object input) throws DatabaseException {

		if (!(input instanceof Resource))
			return false;
		Resource resource = (Resource) input;

		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);
		for(Resource r : graph.getObjects(configuration, SEL.AbstractResourceTabContribution_HasTest)) {
			Boolean pass = Functions.exec(graph, r, graph, resource);
			if(!pass) return false;
		}
		
		return true;
		
	}
	
	@Override
	final public void contribute(ReadGraph graph, final Resource resource, Collection<ComparableTabContributor> result) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);

		Integer priority = graph.getPossibleRelatedValue(configuration, SEL.AbstractResourceTabContribution_HasPriority, Bindings.INTEGER);
		String label = graph.getPossibleRelatedValue(configuration, L0.HasLabel);

		getContributors(graph, resource, priority, label, result);

	}

}
