/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.imports.internal;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.imports.ImportModulesAction;
import org.simantics.scl.ui.imports.internal.Messages;

public class ManageImportsDialog
extends TrayDialog {
    private static final String DIALOG = "ManageImportsDialog";
    TableViewer tableViewer;
    ArrayList<CommandSessionImportEntry> imports;
    IDialogSettings dialogBoundsSettings;

    public ManageImportsDialog(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        super(shell);
        this.imports = imports;
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ManageImportsDialog_ManageImports);
        newShell.setMinimumSize(800, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite tableComposite = new Composite(composite, 0);
        TableColumnLayout tcl = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        this.tableViewer = new TableViewer(tableComposite, 67586);
        Display display = this.getShell().getDisplay();
        final Color black = display.getSystemColor(2);
        final Color gray = display.getSystemColor(15);
        final Color red = display.getSystemColor(3);
        final Font systemFont = display.getSystemFont();
        final Font bold = FontDescriptor.createFrom((Font)systemFont).setStyle(1).createFont((Device)display);
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bold.dispose();
            }
        });
        TableViewerColumn column1 = new TableViewerColumn(this.tableViewer, 0);
        column1.getColumn().setWidth(300);
        column1.getColumn().setText(Messages.ManageImportsDialog_Module);
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CommandSessionImportEntry)element).moduleName;
            }

            public Color getForeground(Object element) {
                CommandSessionImportEntry entry = (CommandSessionImportEntry)element;
                if (entry.disabled) {
                    return gray;
                }
                if (entry.hasError) {
                    return red;
                }
                return black;
            }

            public Font getFont(Object element) {
                CommandSessionImportEntry entry = (CommandSessionImportEntry)element;
                if (entry.persistent) {
                    return bold;
                }
                return systemFont;
            }
        });
        column1.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            CellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)ManageImportsDialog.this.tableViewer.getTable());
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((CommandSessionImportEntry)element).moduleName;
            }

            protected void setValue(Object element, Object value) {
                ((CommandSessionImportEntry)element).moduleName = (String)value;
                this.getViewer().update(element, null);
            }
        });
        TableViewerColumn column2 = new TableViewerColumn(this.tableViewer, 0);
        column2.getColumn().setWidth(100);
        column2.getColumn().setText(Messages.ManageImportsDialog_LocalName);
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CommandSessionImportEntry)element).localName;
            }
        });
        column2.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            CellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)ManageImportsDialog.this.tableViewer.getTable());
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((CommandSessionImportEntry)element).localName;
            }

            protected void setValue(Object element, Object value) {
                ((CommandSessionImportEntry)element).localName = (String)value;
                this.getViewer().update(element, null);
            }
        });
        TableViewerColumn column3 = new TableViewerColumn(this.tableViewer, 0);
        column3.getColumn().setWidth(200);
        column3.getColumn().setText(Messages.ManageImportsDialog_Status);
        column3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CommandSessionImportEntry)element).getStatusString();
            }
        });
        tcl.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 300));
        tcl.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 150));
        tcl.setColumnData((Widget)column3.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 200));
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        final Menu menu = new Menu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                TableItem[] tableItems = ManageImportsDialog.this.tableViewer.getTable().getSelection();
                final CommandSessionImportEntry[] entries = new CommandSessionImportEntry[tableItems.length];
                int i2 = 0;
                while (i2 < tableItems.length) {
                    entries[i2] = (CommandSessionImportEntry)tableItems[i2].getData();
                    ++i2;
                }
                boolean hasPersistent = false;
                boolean hasTransient = false;
                boolean hasEnabled = false;
                boolean hasDisabled = false;
                CommandSessionImportEntry[] commandSessionImportEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    CommandSessionImportEntry entry = commandSessionImportEntryArray[n2];
                    if (entry.persistent) {
                        hasPersistent = true;
                    } else {
                        hasTransient = true;
                    }
                    if (entry.disabled) {
                        hasDisabled = true;
                    } else {
                        hasEnabled = true;
                    }
                    ++n2;
                }
                MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setText(Messages.ManageImportsDialog_Delete);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        THashSet removedEntries = new THashSet(Arrays.asList(entries));
                        ArrayList<CommandSessionImportEntry> newImports = new ArrayList<CommandSessionImportEntry>((this).ManageImportsDialog.this.imports.size());
                        for (CommandSessionImportEntry entry : (this).ManageImportsDialog.this.imports) {
                            if (removedEntries.contains((Object)entry)) continue;
                            newImports.add(entry);
                        }
                        (this).ManageImportsDialog.this.imports = newImports;
                        ManageImportsDialog.this.setInput();
                    }
                });
                if (hasTransient) {
                    menuItem = new MenuItem(menu, 0);
                    menuItem.setText(Messages.ManageImportsDialog_MakePersistent);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            CommandSessionImportEntry[] commandSessionImportEntryArray = entries;
                            int n = entries.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CommandSessionImportEntry entry = commandSessionImportEntryArray[n2];
                                entry.persistent = true;
                                ++n2;
                            }
                            ManageImportsDialog.this.setInput();
                        }
                    });
                }
                if (hasPersistent) {
                    menuItem = new MenuItem(menu, 0);
                    menuItem.setText(Messages.ManageImportsDialog_MakeTransient);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            CommandSessionImportEntry[] commandSessionImportEntryArray = entries;
                            int n = entries.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CommandSessionImportEntry entry = commandSessionImportEntryArray[n2];
                                entry.persistent = false;
                                ++n2;
                            }
                            ManageImportsDialog.this.setInput();
                        }
                    });
                }
                if (hasDisabled) {
                    menuItem = new MenuItem(menu, 0);
                    menuItem.setText(Messages.ManageImportsDialog_Enable);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            CommandSessionImportEntry[] commandSessionImportEntryArray = entries;
                            int n = entries.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CommandSessionImportEntry entry = commandSessionImportEntryArray[n2];
                                entry.disabled = false;
                                ++n2;
                            }
                            ManageImportsDialog.this.setInput();
                        }
                    });
                }
                if (hasEnabled) {
                    menuItem = new MenuItem(menu, 0);
                    menuItem.setText(Messages.ManageImportsDialog_Disable);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            CommandSessionImportEntry[] commandSessionImportEntryArray = entries;
                            int n = entries.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CommandSessionImportEntry entry = commandSessionImportEntryArray[n2];
                                entry.disabled = true;
                                ++n2;
                            }
                            ManageImportsDialog.this.setInput();
                        }
                    });
                }
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setInput();
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().applyTo(buttonComposite);
        BundleContext context = Activator.getInstance().getBundle().getBundleContext();
        ArrayList<ImportModulesAction> actions = new ArrayList<ImportModulesAction>();
        try {
            for (ServiceReference ref : context.getServiceReferences(ImportModulesAction.class, null)) {
                ImportModulesAction action = (ImportModulesAction)context.getService(ref);
                actions.add(action);
            }
        }
        catch (InvalidSyntaxException e1) {
            e1.printStackTrace();
        }
        Collections.sort(actions);
        for (final ImportModulesAction action : actions) {
            Button button = new Button(buttonComposite, 0);
            GridDataFactory.fillDefaults().applyTo((Control)button);
            button.setText(action.name);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (action.editImports(ManageImportsDialog.this.getShell(), ManageImportsDialog.this.imports)) {
                        ManageImportsDialog.this.setInput();
                    }
                }
            });
        }
        return composite;
    }

    private void setInput() {
        Object[] array = this.imports.toArray(new CommandSessionImportEntry[this.imports.size()]);
        Arrays.sort(array);
        this.tableViewer.setInput((Object)array);
    }

    public ArrayList<CommandSessionImportEntry> getImports() {
        return this.imports;
    }

    protected boolean isResizable() {
        return true;
    }
}

