/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor;

import java.util.Iterator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.ui.editor.SCLAnnotationAccessNew;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.SharedTextColorsNew;

public class SCLTextEditorNew
extends Composite {
    private static final int DELAY_BEFORE_COMPILATION = 500;
    public SourceViewer viewer;
    ImageRegistry imageRegistry;
    SCLAnnotationAccessNew annotationAccess;
    ISharedTextColors sharedTextColors;
    IAnnotationModel annotationModel;
    private Point storedSelectedRange;

    public SCLTextEditorNew(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.imageRegistry = new ImageRegistry(parent.getDisplay());
        this.annotationAccess = new SCLAnnotationAccessNew(this.imageRegistry);
        this.sharedTextColors = new SharedTextColorsNew(this.getDisplay());
        this.annotationModel = new AnnotationModel();
        VerticalRuler leftRuler = new VerticalRuler(12, (IAnnotationAccess)this.annotationAccess);
        leftRuler.setModel(this.annotationModel);
        OverviewRuler rightRuler = new OverviewRuler((IAnnotationAccess)this.annotationAccess, 12, this.sharedTextColors);
        rightRuler.setModel(this.annotationModel);
        rightRuler.addAnnotationType((Object)"error");
        rightRuler.setAnnotationTypeLayer((Object)"error", 0);
        rightRuler.setAnnotationTypeColor((Object)"error", this.sharedTextColors.getColor(new RGB(255, 0, 128)));
        this.viewer = new SourceViewer((Composite)this, (IVerticalRuler)leftRuler, (IOverviewRuler)rightRuler, true, 768);
        Document document = new Document();
        this.viewer.showAnnotations(false);
        this.viewer.showAnnotationsOverview(false);
        this.viewer.setDocument((IDocument)document, this.annotationModel);
        this.viewer.setEditable(true);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), this.viewer.getControl());
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew((ResourceManager)resourceManager);
        this.viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        AnnotationPainter annotationPainter = new AnnotationPainter((ISourceViewer)this.viewer, (IAnnotationAccess)this.annotationAccess);
        annotationPainter.addAnnotationType((Object)"error");
        annotationPainter.setAnnotationTypeColor((Object)"error", this.sharedTextColors.getColor(new RGB(255, 0, 128)));
        this.viewer.addPainter((IPainter)annotationPainter);
        this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)annotationPainter);
        TextViewerUndoManager undoManager = new TextViewerUndoManager(100);
        this.viewer.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.viewer);
    }

    public IUndoManager getUndoManager() {
        return this.viewer.getUndoManager();
    }

    public void dispose() {
        super.dispose();
        this.sharedTextColors.dispose();
    }

    private void removeAnnotations() {
        Iterator it = this.annotationModel.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation = (Annotation)it.next();
            this.annotationModel.removeAnnotation(annotation);
        }
    }

    private void setAnnotations(CompilationError[] errors) {
        this.removeAnnotations();
        CompilationError[] compilationErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            CompilationError error = compilationErrorArray[n2];
            int begin = Locations.beginOf((long)error.location);
            if (begin == (end = Locations.endOf((long)error.location))) {
                if (begin > 0) {
                    --begin;
                } else {
                    ++end;
                }
            }
            this.annotationModel.addAnnotation(new Annotation("error", true, error.description), new Position(begin, end - begin));
            ++n2;
        }
    }

    public String getContent() {
        final String[] result = new String[1];
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = SCLTextEditorNew.this.viewer.getDocument().get();
            }
        });
        return result[0];
    }

    public void setContent(final String content, final CompilationError[] errors) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SCLTextEditorNew.this.viewer.getTextWidget().isDisposed()) {
                    return;
                }
                if (content != null) {
                    SCLTextEditorNew.this.viewer.getDocument().set(content);
                }
                if (errors != null) {
                    SCLTextEditorNew.this.setAnnotations(errors);
                }
            }
        });
    }

    public void storeSelectedRange() {
        this.storedSelectedRange = this.viewer.getSelectedRange();
    }

    public void restoreSelectedRange() {
        if (this.storedSelectedRange != null) {
            this.viewer.setSelectedRange(this.storedSelectedRange.x, this.storedSelectedRange.y);
            this.storedSelectedRange = null;
        }
    }
}

