/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.procedure;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class StringIO {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static List<String> readLines(String fileName) throws IOException {
        try {
            return Files.readAllLines(Paths.get(fileName, new String[0]), UTF8);
        }
        catch (MalformedInputException malformedInputException) {
            throw new RuntimeException("Encoding of the file '" + fileName + "' does not conform to UTF-8 (without BOM).");
        }
    }

    public static List<String> readLinesWithCharset(String charset, String fileName) throws IOException {
        try {
            return Files.readAllLines(Paths.get(fileName, new String[0]), Charset.forName(charset));
        }
        catch (MalformedInputException malformedInputException) {
            throw new RuntimeException("Encoding of the file '" + fileName + "' does not conform to " + charset + ".");
        }
    }

    public static String readContentsWithCharset(String charset, String fileName) throws IOException {
        try {
            Charset cs = Charset.forName(charset);
            return new String(Files.readAllBytes(Paths.get(fileName, new String[0])), cs);
        }
        catch (MalformedInputException malformedInputException) {
            throw new RuntimeException("Encoding of the file '" + fileName + "' does not conform to " + charset + ".");
        }
    }

    public static void writeLines(String fileName, List<String> lines) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(Paths.get(fileName, new String[0]), UTF8, new OpenOption[0]);
        for (String line : lines) {
            writer.write(line);
            writer.write("\n");
        }
        writer.close();
    }

    public static void appendLine(String fileName, String line) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(Paths.get(fileName, new String[0]), UTF8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        writer.write(line);
        writer.write("\n");
        writer.close();
    }
}

