/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class WriteProgressInterceptor
implements WriterInterceptor {
    private Function1<Long, Tuple0> callback;

    public WriteProgressInterceptor(Function1<Long, Tuple0> callback) {
        this.callback = callback;
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        OutputStream os = context.getOutputStream();
        context.setOutputStream((OutputStream)new FilterOutputStream(os){
            private long count;

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
                this.count += (long)len;
                WriteProgressInterceptor.this.callback.apply((Object)this.count);
            }

            @Override
            public void write(int b) throws IOException {
                this.out.write(b);
                ++this.count;
                WriteProgressInterceptor.this.callback.apply((Object)this.count);
            }
        });
        context.proceed();
    }
}

