/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.scl.compiler.commands.CommandSessionWithModules;
import org.simantics.scl.osgi.SCLOsgi;

public class SCLAPI {
    private static SCLAPI INSTANCE;
    private ConcurrentHashMap<String, CommandSessionWithModules> commandSessions = new ConcurrentHashMap();

    private SCLAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SCLAPI getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SCLAPI> clazz = SCLAPI.class;
        synchronized (SCLAPI.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SCLAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public CommandSessionWithModules getOrCreateCommandSession(String sessionId) {
        return this.commandSessions.computeIfAbsent(sessionId, key -> new CommandSessionWithModules(SCLOsgi.MODULE_REPOSITORY));
    }

    public void execute(String sessionId, Reader reader, Writer writer) {
        CommandSessionWithModules session = this.commandSessions.get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("CommandSession for sessionId " + sessionId + " does not exist!");
        }
        session.runCommands(reader, writer);
    }

    public void deleteCommandSession(String sessionId) {
        this.commandSessions.computeIfPresent(sessionId, (key, session) -> null);
    }

    public Object variableValue(String sessionId, String variableName) {
        CommandSessionWithModules session = this.commandSessions.get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("CommandSession for sessionId " + sessionId + " does not exist!");
        }
        return session.getCommandSession().getVariableValue(variableName);
    }

    public String putModule(String sessionId, String moduleName, String moduleText) {
        CommandSessionWithModules session = this.commandSessions.get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("CommandSession for sessionId " + sessionId + " does not exist!");
        }
        return session.putModule(moduleName, moduleText);
    }
}

