package org.simantics.scl.osgi.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.scl.osgi.internal.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCLIssueFactoryProvider {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLIssueFactoryProvider.class);

    public static List<SCLIssueProviderFactory> getSCLIssueProviderFactories() {
        ServiceReference<?>[] serviceReferences = new ServiceReference<?>[0];
        try {
            serviceReferences = Activator.getContext().getAllServiceReferences(SCLIssueProviderFactory.class.getName(), null);
        } catch (InvalidSyntaxException e) {
            LOGGER.error("Could not get service references for " + SCLIssueProviderFactory.class.getName(), e);
        }
        if (serviceReferences == null || serviceReferences.length == 0)
            return Collections.emptyList();

        List<SCLIssueProviderFactory> services = new ArrayList<>(serviceReferences.length);
        for (ServiceReference<?> reference : serviceReferences) {
            SCLIssueProviderFactory service = (SCLIssueProviderFactory) Activator.getContext().getService(reference);
            services.add(service);
        }
        return services;
    }

}
