package org.simantics.scl.osgi.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.compiler.testing.repository.TestRepository;

import gnu.trove.map.hash.THashMap;

@Component
public class BundleTestScriptRepository implements TestRepository {
    
    Tracker tracker;
    THashMap<String, BundleTestScriptRunnable> testsRunnables = new THashMap<String, BundleTestScriptRunnable>();
    THashMap<Bundle, ArrayList<String>> testsPerBundle = new THashMap<Bundle, ArrayList<String>>();

    @Activate
    public void activate(ComponentContext context) {
        tracker = new Tracker(context.getBundleContext());
        tracker.open();
    }
    
    @Deactivate
    public void deactivate() {
        tracker.close();
    }
    
    class Tracker extends BundleTracker<Bundle> {
        public Tracker(BundleContext context) {
            super(context, 0xffffffff, null);
        }
        
        @Override
        synchronized public Bundle addingBundle(Bundle bundle, BundleEvent event) {
            Enumeration<URL> urls = bundle.findEntries("sclTests", "*.sts", true);
            if(urls != null) {
                ArrayList<String> modulesInThisBundle = new ArrayList<String>();
                while(urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    String path = url.getPath();
                    String testName = path.substring(10, path.length()-4);
                    testsRunnables.put(testName, new BundleTestScriptRunnable(testName, url));
                    modulesInThisBundle.add(testName);
                }
                testsPerBundle.put(bundle, modulesInThisBundle);
            }
            return bundle;
        }
        
        @Override
        synchronized public void removedBundle(Bundle bundle, BundleEvent event,
                Bundle object) {
            ArrayList<String> moduleList = testsPerBundle.get(bundle);
            if(moduleList != null)
                for(String moduleName : moduleList)
                    testsRunnables.remove(moduleName);
        }
    };
    
    @Override
    public void collectTests(Collection<TestRunnable> tests) {
        tests.addAll(testsRunnables.values());
    }

}
