package org.simantics.scl.expressions.datatype;

import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class DatatypeConversion {

    private static final Datatype.Visitor<Type> conversionVisitor = new Datatype.Visitor<Type>() {

        @Override
        public Type visit(ArrayType b) {
            return Types.apply(Types.LIST, b.componentType.accept(this));
        }

        @Override
        public Type visit(BooleanType b) {
            return Types.BOOLEAN;
        }

        @Override
        public Type visit(DoubleType b) {
            return Types.DOUBLE;
        }

        @Override
        public Type visit(FloatType b) {
            return Types.FLOAT;
        }

        @Override
        public Type visit(IntegerType b) {
            return Types.INTEGER;
        }

        @Override
        public Type visit(ByteType b) {
            return Types.BYTE;
        }

        @Override
        public Type visit(LongType b) {
            return Types.LONG;
        }

        @Override
        public Type visit(OptionalType b) {
            return Types.apply(Types.MAYBE, b.componentType.accept(this));
        }

        @Override
        public Type visit(RecordType b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type visit(StringType b) {
            return Types.STRING;
        }

        @Override
        public Type visit(UnionType b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type visit(VariantType b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type visit(MapType b) {
            throw new UnsupportedOperationException();
        }

    };

    public static Type convertDatatypeToType(Datatype dataType) {
        return dataType.accept(conversionVisitor);
    }

}
