/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.types.TCon;

public abstract class AbstractEnvironment
implements Environment {
    protected abstract Module getModule(String var1);

    protected abstract Collection<Module> getModules();

    @Override
    public SCLValue getValue(Name name) {
        Module module = this.getModule(name.module);
        if (module == null) {
            return null;
        }
        return module.getValue(name.name);
    }

    @Override
    public SCLRelation getRelation(Name name) {
        Module module = this.getModule(name.module);
        if (module == null) {
            return null;
        }
        return module.getRelation(name.name);
    }

    @Override
    public SCLEntityType getEntityType(Name name) {
        Module module = this.getModule(name.module);
        if (module == null) {
            return null;
        }
        return module.getEntityType(name.name);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(TCon type) {
        Module module = this.getModule(type.module);
        if (module == null) {
            return null;
        }
        return module.getTypeDescriptor(type.name);
    }

    @Override
    public EffectConstructor getEffectConstructor(TCon type) {
        Module module = this.getModule(type.module);
        if (module == null) {
            return null;
        }
        return module.getEffectConstructor(type.name);
    }

    @Override
    public TypeClass getTypeClass(TCon type) {
        Module module = this.getModule(type.module);
        if (module == null) {
            return null;
        }
        return module.getTypeClass(type.name);
    }

    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        Collection<TypeClassInstance> result = Collections.emptyList();
        int nonemptySubresults = 0;
        for (Module module : this.getModules()) {
            Collection<TypeClassInstance> instances = module.getInstances(typeClass);
            if (instances.isEmpty()) continue;
            switch (nonemptySubresults) {
                case 0: {
                    result = instances;
                    break;
                }
                case 1: {
                    ArrayList<TypeClassInstance> temp = new ArrayList<TypeClassInstance>((result.size() + instances.size()) * 3 / 2);
                    temp.addAll(result);
                    result = temp;
                }
                default: {
                    result.addAll(instances);
                }
            }
            ++nonemptySubresults;
        }
        return result;
    }
}

