/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class IntegerConstant
extends Constant {
    public static final IntegerConstant ZERO = new IntegerConstant(0);
    public static final IntegerConstant ONE = new IntegerConstant(1);
    public static final IntegerConstant MINUS_ONE = new IntegerConstant(-1);
    int value;

    public IntegerConstant(int value) {
        super(Types.INTEGER);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerConstant other = (IntegerConstant)obj;
        return this.value == other.value;
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        mb.push(parameter, Types.INTEGER);
        mb.loadConstant(this.value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.INT);
        mb.jump(success);
    }

    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

