/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.TypeInferableDefinition;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.internal.elaboration.utils.StronglyConnectedComponents;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;

public class TypeCheckingScheduler {
    private final CompilationContext compilationContext;
    private final ArrayList<TypeInferableDefinition> definitions = new ArrayList();
    private final ArrayList<Runnable> postTypeCheckingRunnables = new ArrayList();

    public TypeCheckingScheduler(CompilationContext compilationContext) {
        this.compilationContext = compilationContext;
    }

    public void addTypeInferableDefinition(TypeInferableDefinition definition) {
        this.definitions.add(definition);
    }

    public void addPostTypeCheckingRunnable(Runnable runnable) {
        this.postTypeCheckingRunnables.add(runnable);
    }

    public void schedule() {
        final TObjectIntHashMap allRefs = new TObjectIntHashMap(this.definitions.size(), 0.5f, -1);
        int i = 0;
        while (i < this.definitions.size()) {
            for (Object definedObject : this.definitions.get(i).getDefinedObjects()) {
                allRefs.put(definedObject, i);
            }
            ++i;
        }
        new StronglyConnectedComponents(this.definitions.size()){
            TIntHashSet set;
            {
                super($anonymous0);
                this.set = new TIntHashSet();
            }

            @Override
            protected void reportComponent(int[] component) {
                TypeCheckingScheduler.this.typeCheck(component);
            }

            @Override
            protected int[] findDependencies(int u) {
                ((TypeInferableDefinition)TypeCheckingScheduler.this.definitions.get(u)).collectRefs((TObjectIntHashMap<Object>)allRefs, this.set);
                int[] result = this.set.toArray();
                this.set.clear();
                return result;
            }
        }.findComponents();
        for (Runnable runnable : this.postTypeCheckingRunnables) {
            runnable.run();
        }
    }

    private void typeCheck(int[] component) {
        int c;
        TypingContext context = new TypingContext(this.compilationContext);
        context.recursiveValues = new THashSet();
        int[] nArray = component;
        int n = component.length;
        int n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.definitions.get(c).initializeTypeChecking(context);
            ++n2;
        }
        nArray = component;
        n = component.length;
        n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.definitions.get(c).checkType(context);
            ++n2;
        }
        context.solveSubsumptions(this.definitions.get(component[0]).getLocation());
        nArray = component;
        n = component.length;
        n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.definitions.get(c).solveConstraints();
            ++n2;
        }
        THashSet varSet = new THashSet();
        int[] nArray2 = component;
        int n3 = component.length;
        n = 0;
        while (n < n3) {
            int c2 = nArray2[n];
            this.definitions.get(c2).collectFreeTypeVariables((THashSet<TVar>)varSet);
            ++n;
        }
        TVar[] vars = (TVar[])varSet.toArray((Object[])new TVar[varSet.size()]);
        THashSet constraintSet = new THashSet();
        int[] nArray3 = component;
        int n4 = component.length;
        int n5 = 0;
        while (n5 < n4) {
            int c3 = nArray3[n5];
            for (Variable evidence : this.definitions.get(c3).getFreeEvidence()) {
                constraintSet.add((Object)((TPred)evidence.getType()));
            }
            ++n5;
        }
        TPred[] constraints = (TPred[])constraintSet.toArray((Object[])new TPred[constraintSet.size()]);
        THashMap constraintMap = null;
        Object object = constraints;
        int n6 = constraints.length;
        int n7 = 0;
        while (n7 < n6) {
            Object constraint = object[n7];
            if (((TPred)constraint).containsMetaVars()) {
                if (constraintMap == null) {
                    constraintMap = new THashMap();
                    int[] nArray4 = component;
                    int n8 = component.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        int c4 = nArray4[n9];
                        for (Constraint cons : this.definitions.get(c4).getUnsolvedConstraints()) {
                            constraintMap.put((Object)cons.constraint, (Object)cons);
                        }
                        ++n9;
                    }
                }
                Constraint cons = (Constraint)constraintMap.get(constraint);
                this.compilationContext.errorLog.log(cons.getDemandLocation(), "Constrain " + constraint + " contains free variables not mentioned in the type of the value.");
            }
            ++n7;
        }
        object = component;
        n6 = component.length;
        n7 = 0;
        while (n7 < n6) {
            TPred c5 = object[n7];
            this.definitions.get((int)c5).injectEvidence(vars, constraints);
            ++n7;
        }
    }
}

