/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.commands;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.compiler.commands.CompiledCommand;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.compiler.commands.ValueToStringConverter;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.dynamic.SafeDynamic;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.environment.AbstractLocalEnvironment;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.LocalEnvironment;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.ErrorSeverity;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.utils.NameMangling;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.utils.LaxUTF8Reader;
import org.simantics.scl.compiler.internal.parsing.utils.MemoReader;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.ExpressionEvaluator;
import org.simantics.scl.compiler.top.LocalStorage;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl2;
import org.simantics.scl.runtime.reporting.DelegatingSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReporting;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSession.class);
    ModuleRepository moduleRepository;
    SCLReportingHandler defaultHandler;
    RuntimeEnvironment runtimeEnvironment;
    ValueToStringConverter valueToStringConverter;
    ArrayList<CommandSessionImportEntry> importEntries = new ArrayList();
    THashMap<String, Object> variableValues = new THashMap();
    THashMap<String, Type> variableTypes = new THashMap();
    PrintStream fileOutput;
    private UpdateListener dependenciesListener;
    private boolean validateOnly;
    private LocalStorage localStorage = new LocalStorage(){

        @Override
        public void store(String name, Object value, Type type) {
            CommandSession.this.variableValues.put((Object)name, value);
            CommandSession.this.variableTypes.put((Object)name, (Object)type);
        }
    };
    private static final THashMap<String, LocalFunction> LOCAL_FUNCTIONS = new THashMap();
    private static final String THIS_CLASS_NAME;

    static {
        LOCAL_FUNCTIONS.put((Object)"runFromFile", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, String, Tuple0>(){

            public Tuple0 apply(CommandSession commandSession, String fileName) {
                SCLContext context = SCLContext.getCurrent();
                commandSession.runFromFile(fileName, (SCLReportingHandler)context.get((Object)"reportingHandler"));
                return Tuple0.INSTANCE;
            }
        }, Types.functionE(Types.STRING, (Type)Types.PROC, (Type)Types.UNIT)));
        LOCAL_FUNCTIONS.put((Object)"runTest", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, String, Tuple0>(){

            public Tuple0 apply(CommandSession commandSession, String fileName) {
                SCLContext context = SCLContext.getCurrent();
                SCLReportingHandler handler = (SCLReportingHandler)context.get((Object)"reportingHandler");
                try (BufferedReader reader = new BufferedReader(new LaxUTF8Reader(fileName));){
                    new TestScriptExecutor(commandSession, reader, handler).execute();
                }
                catch (IOException e) {
                    handler.printError(e.getMessage());
                }
                return Tuple0.INSTANCE;
            }
        }, Types.functionE(Types.STRING, (Type)Types.PROC, (Type)Types.UNIT)));
        LOCAL_FUNCTIONS.put((Object)"reset", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, Tuple0, Tuple0>(){

            public Tuple0 apply(CommandSession commandSession, Tuple0 dummy) {
                commandSession.removeTransientImports();
                commandSession.removeVariables();
                commandSession.moduleRepository.getSourceRepository().checkUpdates();
                commandSession.updateRuntimeEnvironment(true);
                return Tuple0.INSTANCE;
            }
        }, Types.functionE(Types.UNIT, (Type)Types.PROC, (Type)Types.UNIT)));
        LOCAL_FUNCTIONS.put((Object)"variables", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, Tuple0, List<String>>(){

            public List<String> apply(CommandSession commandSession, Tuple0 dummy) {
                ArrayList<String> result = new ArrayList<String>(commandSession.variableTypes.keySet());
                Collections.sort(result);
                return result;
            }
        }, Types.functionE(Types.PUNIT, (Type)Types.PROC, Types.list(Types.STRING))));
        LOCAL_FUNCTIONS.put((Object)"startPrintingToFile", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, String, Tuple0>(){

            public Tuple0 apply(CommandSession commandSession, String fileName) {
                try {
                    if (commandSession.fileOutput != null) {
                        commandSession.fileOutput.close();
                        SCLReporting.printError((String)"Printing to file was already enabled. Stopped the previous printing.");
                    }
                    commandSession.fileOutput = new PrintStream(fileName, "UTF-8");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                return Tuple0.INSTANCE;
            }
        }, Types.functionE(Types.STRING, (Type)Types.PROC, (Type)Types.UNIT)));
        LOCAL_FUNCTIONS.put((Object)"startAppendingToFile", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, String, Tuple0>(){

            public Tuple0 apply(CommandSession commandSession, String fileName) {
                try {
                    if (commandSession.fileOutput != null) {
                        commandSession.fileOutput.close();
                        SCLReporting.printError((String)"Printing to file was already enabled. Stopped the previous printing.");
                    }
                    FileOutputStream stream = new FileOutputStream(fileName, true);
                    commandSession.fileOutput = new PrintStream((OutputStream)stream, false, "UTF-8");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                return Tuple0.INSTANCE;
            }
        }, Types.functionE(Types.STRING, (Type)Types.PROC, (Type)Types.UNIT)));
        LOCAL_FUNCTIONS.put((Object)"stopPrintingToFile", (Object)new LocalFunction((Function)new FunctionImpl2<CommandSession, Tuple0, Tuple0>(){

            public Tuple0 apply(CommandSession commandSession, Tuple0 dummy) {
                if (commandSession.fileOutput != null) {
                    commandSession.fileOutput.close();
                    commandSession.fileOutput = null;
                }
                return Tuple0.INSTANCE;
            }
        }, Types.functionE(Types.PUNIT, (Type)Types.PROC, (Type)Types.UNIT)));
        THIS_CLASS_NAME = CommandSession.class.getName();
    }

    public CommandSession(ModuleRepository moduleRepository) {
        this(moduleRepository, SCLReporting.getCurrentReportingHandler());
    }

    public CommandSession(ModuleRepository moduleRepository, SCLReportingHandler handler) {
        this.moduleRepository = moduleRepository;
        this.defaultHandler = new PrintDecorator(handler == null ? SCLReportingHandler.DEFAULT : handler);
        this.updateRuntimeEnvironment(true);
    }

    private static EnvironmentSpecification createEnvironmentSpecification(Collection<CommandSessionImportEntry> importEntries) {
        EnvironmentSpecification spec = new EnvironmentSpecification();
        spec.importModule("Builtin", "");
        spec.importModule("StandardLibrary", "");
        spec.importModule("Expressions/Context", null);
        for (CommandSessionImportEntry entry : importEntries) {
            if (entry.disabled || entry.hasError) continue;
            spec.importModule(entry.moduleName, entry.localName);
        }
        return spec;
    }

    /*
     * Unable to fully structure code
     */
    public void updateRuntimeEnvironment(boolean clearErrorsFlags) {
        block14: {
            if (clearErrorsFlags) {
                for (CommandSessionImportEntry entry : this.importEntries) {
                    entry.hasError = false;
                }
            }
            environmentSpecification = CommandSession.createEnvironmentSpecification(this.importEntries);
            this.runtimeEnvironment = null;
            try {
                if (this.dependenciesListener != null) {
                    this.dependenciesListener.stopListening();
                }
                try {
                    this.runtimeEnvironment = this.moduleRepository.createRuntimeEnvironment(environmentSpecification, this.getClass().getClassLoader(), this.dependenciesListener);
                    break block14;
                }
                catch (ImportFailureException e) {
                    failedModules = new THashSet();
                    ** for (failure : e.failures)
                }
lbl-1000:
                // 1 sources

                {
                    failedModules.add((Object)failure.moduleName);
                    this.defaultHandler.printError(failure.toString());
                    if (!(failure.reason instanceof CompilationError[])) continue;
                    var10_13 = (CompilationError[])failure.reason;
                    var9_12 = var10_13.length;
                    var8_11 = 0;
                    while (var8_11 < var9_12) {
                        error = var10_13[var8_11];
                        if (error.severity != ErrorSeverity.WARNING) {
                            this.defaultHandler.printError("    " + error.description);
                        }
                        ++var8_11;
                    }
                    continue;
                }
lbl31:
                // 3 sources

                for (CommandSessionImportEntry entry : this.importEntries) {
                    if (!failedModules.contains((Object)entry.moduleName)) continue;
                    entry.hasError = true;
                }
                environmentSpecification = CommandSession.createEnvironmentSpecification(this.importEntries);
                try {
                    this.runtimeEnvironment = this.moduleRepository.createRuntimeEnvironment(environmentSpecification, this.getClass().getClassLoader());
                    break block14;
                }
                catch (ImportFailureException e1) {
                    ** for (failure : e1.failures)
                }
lbl-1000:
                // 1 sources

                {
                    this.defaultHandler.printError(failure.toString());
                    continue;
lbl43:
                    // 1 sources

                }
            }
            catch (RuntimeException e) {
                CommandSession.LOGGER.error("updateRuntimeEnvironment(clearErrorsFlags={}) failed", (Object)clearErrorsFlags, (Object)e);
                throw e;
            }
        }
        this.valueToStringConverter = new ValueToStringConverter(this.runtimeEnvironment);
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public ModuleRepository getModuleRepository() {
        return this.moduleRepository;
    }

    private LocalEnvironment createLocalEnvironment() {
        return new AbstractLocalEnvironment(){
            Variable contextVariable = new Variable("context", Names.Expressions_Context_Context);

            @Override
            public Expression resolve(Environment environment, String localName) {
                Type type = (Type)CommandSession.this.variableTypes.get((Object)localName);
                if (type != null) {
                    return new EApply((Expression)new EConstant(environment.getValue(Names.Expressions_Context_contextGet), type), new EVariable(this.contextVariable), new ELiteral(new StringConstant(localName)));
                }
                LocalFunction localFunction = (LocalFunction)LOCAL_FUNCTIONS.get((Object)localName);
                if (localFunction != null) {
                    return new EExternalConstant(localFunction.function.apply((Object)CommandSession.this), localFunction.type);
                }
                return null;
            }

            @Override
            protected Variable[] getContextVariables() {
                return new Variable[]{this.contextVariable};
            }

            @Override
            public void forNames(TObjectProcedure<String> proc) {
                for (String name : CommandSession.this.variableTypes.keySet()) {
                    proc.execute((Object)name);
                }
                for (String name : LOCAL_FUNCTIONS.keySet()) {
                    proc.execute((Object)name);
                }
            }
        };
    }

    protected void removeTransientImports() {
        ArrayList<CommandSessionImportEntry> newEntries = new ArrayList<CommandSessionImportEntry>(this.importEntries.size());
        for (CommandSessionImportEntry entry : this.importEntries) {
            if (!entry.persistent) continue;
            newEntries.add(entry);
        }
        this.importEntries = newEntries;
    }

    public THashMap<String, Type> localNamesForContentProposals() {
        THashMap result = new THashMap();
        for (Map.Entry entry : LOCAL_FUNCTIONS.entrySet()) {
            result.put((Object)((String)entry.getKey()), (Object)((LocalFunction)entry.getValue()).type);
        }
        result.putAll(this.variableTypes);
        return result;
    }

    private CompiledCommand compile(Expression expression) throws SCLExpressionCompilationException {
        LocalEnvironment localEnvironment = this.createLocalEnvironment();
        if (this.runtimeEnvironment == null) {
            throw new SCLExpressionCompilationException(new CompilationError[]{new CompilationError("Compilation failed: imports in the current environment have failed.")});
        }
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.runtimeEnvironment, this.localStorage, expression);
        Function command = (Function)evaluator.localEnvironment(localEnvironment).decorateExpression(true).validateOnly(this.validateOnly).eval();
        return new CompiledCommand(command, evaluator.getType());
    }

    /*
     * Unable to fully structure code
     */
    private void execute(MemoReader reader, Expression expression, SCLReportingHandler handler) {
        context = SCLContext.getCurrent();
        oldPrinter = context.put((Object)"reportingHandler", (Object)handler);
        try {
            try {
                block15: {
                    try {
                        handler.printCommand(reader.extractString(expression.location));
                        command = this.compile(expression);
                        break block15;
                    }
                    catch (SCLExpressionCompilationException e) {
                        if (this.validateOnly) {
                            throw e;
                        }
                        var12_12 = errors = e.getErrors();
                        var11_13 = errors.length;
                        var10_14 = 0;
                        ** while (var10_14 < var11_13)
                    }
lbl-1000:
                    // 1 sources

                    {
                        error = var12_12[var10_14];
                        if (error.location != 9223372034707292160L) {
                            handler.printError(reader.locationUnderlining(error.location));
                        }
                        handler.printError(error.description);
                        ++var10_14;
                        continue;
                    }
lbl22:
                    // 1 sources

                    throw new CancelExecution();
                }
                reader.forgetEverythingBefore(Locations.endOf(expression.location));
                if (!this.validateOnly && !(resultString = this.toString(resultValue = command.command.apply(this.variableValues), command.type)).isEmpty()) {
                    handler.print(resultString);
                }
            }
            catch (Exception e) {
                if (this.validateOnly) {
                    throw e;
                }
                if (!(e instanceof CancelExecution)) {
                    if (e instanceof InterruptedException) {
                        handler.printError("Execution interrupted.");
                    } else {
                        CommandSession.formatException(handler, e);
                    }
                }
                throw new CancelExecution();
            }
        }
        finally {
            context.put((Object)"reportingHandler", oldPrinter);
        }
    }

    private String toString(Object value, Type type) {
        if (type.equals(Types.UNIT)) {
            return "";
        }
        try {
            return this.valueToStringConverter.show(value, type);
        }
        catch (SCLExpressionCompilationException sCLExpressionCompilationException) {
            return "<value of type " + type + ">";
        }
    }

    private void checkInterrupted() {
        if (Thread.interrupted()) {
            this.defaultHandler.printError("Execution interrupted.");
            throw new CancelExecution();
        }
    }

    private CompilationError[] validate(Reader commandReader) {
        CommandParser parser = new CommandParser(this.defaultHandler, new MemoReader(commandReader));
        this.validateOnly = true;
        try {
            parser.parseCommands();
            parser.finishBlock();
            CompilationError[] compilationErrorArray = CompilationError.EMPTY_ARRAY;
            return compilationErrorArray;
        }
        catch (SCLExpressionCompilationException e) {
            CompilationError[] compilationErrorArray = e.getErrors();
            return compilationErrorArray;
        }
        catch (SCLSyntaxErrorException e) {
            CompilationError[] compilationErrorArray = new CompilationError[]{new CompilationError(e.location, e.getMessage())};
            return compilationErrorArray;
        }
        catch (Exception e) {
            CompilationError[] compilationErrorArray = new CompilationError[]{new CompilationError(9223372034707292160L, e.getMessage())};
            return compilationErrorArray;
        }
        finally {
            this.validateOnly = false;
        }
    }

    public void execute(Reader commandReader, SCLReportingHandler handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        } else if (!(handler instanceof PrintDecorator)) {
            handler = new PrintDecorator((SCLReportingHandler)handler);
        }
        CommandParser parser = new CommandParser((SCLReportingHandler)handler, new MemoReader(commandReader));
        try {
            parser.parseCommands();
            parser.finishBlock();
        }
        catch (CancelExecution cancelExecution) {
        }
        catch (SCLSyntaxErrorException e) {
            handler.printCommand(parser.reader.getLastCommand());
            if (e.location != 9223372034707292160L) {
                handler.printError(parser.reader.locationUnderlining(e.location));
            }
            handler.printError(e.getMessage());
        }
        catch (AssertionError | Exception e) {
            if (e instanceof InterruptedException) {
                handler.printError("Execution interrupted.");
            }
            CommandSession.formatException(handler, (Throwable)e);
        }
    }

    public void execute(String command) {
        this.execute(new StringReader(command), null);
    }

    public void execute(String command, SCLReportingHandler handler) {
        this.execute(new StringReader(command), handler);
    }

    public static void formatException(SCLReportingHandler handler, Throwable e) {
        CommandSession.formatException(handler, null, e);
    }

    private static void formatException(SCLReportingHandler handler, StackTraceElement[] enclosingTrace, Throwable e) {
        int i;
        int endPos;
        StackTraceElement[] elements;
        block15: {
            elements = e.getStackTrace();
            Throwable cause = e.getCause();
            if (cause != null) {
                CommandSession.formatException(handler, elements, cause);
                handler.printError("Rethrown as ");
            }
            handler.printError(e.toString());
            endPos = elements.length;
            if (enclosingTrace != null) {
                int p = enclosingTrace.length;
                while (endPos > 0 && p > 0 && elements[endPos - 1].equals(enclosingTrace[p - 1])) {
                    --p;
                    --endPos;
                }
            } else {
                i = 0;
                while (i < endPos) {
                    StackTraceElement element = elements[i];
                    if (element.getMethodName().equals("execute") && element.getClassName().equals(THIS_CLASS_NAME)) {
                        endPos = i;
                        while (endPos > 0) {
                            element = elements[endPos - 1];
                            String className = element.getClassName();
                            if (className.startsWith("org.simantics.scl.compiler.top.SCLExpressionCompiler") || className.startsWith("org.simantics.scl.runtime.function.FunctionImpl")) {
                                --endPos;
                                continue;
                            }
                            break block15;
                        }
                        break;
                    }
                    ++i;
                }
            }
        }
        i = 0;
        while (i < endPos) {
            StringBuilder b = new StringBuilder();
            StackTraceElement element = elements[i];
            String className = element.getClassName();
            if (!(className.equals("org.simantics.scl.compiler.interpreted.IApply") || className.equals("org.simantics.scl.compiler.interpreted.ILet") || className.startsWith("tempsclpackage"))) {
                if (className.startsWith("org.simantics.scl.compiler.interpreted.ILambda")) {
                    b.append("\tat command line\n");
                } else {
                    String fileName;
                    String methodName = element.getMethodName();
                    if (!(className.startsWith("org.simantics.scl.runtime.function.FunctionImpl") && methodName.equals("applyArray") || "_SCL_Closure".equals(fileName = element.getFileName()))) {
                        b.append("\tat ");
                        if ("_SCL_Module".equals(fileName) || "_SCL_TypeClassInstance".equals(fileName)) {
                            b.append(className).append('.').append(NameMangling.demangle(methodName)).append('(').append(element.getLineNumber()).append(')');
                        } else {
                            b.append(element);
                        }
                        handler.printError(b.toString());
                    }
                }
            }
            ++i;
        }
    }

    public void setVariable(String name, Type type, Object value) {
        this.variableValues.put((Object)name, value);
        this.variableTypes.put((Object)name, (Object)type);
    }

    public void setVariable(String name, SafeDynamic typeAndValue) {
        this.variableValues.put((Object)name, typeAndValue.value);
        this.variableTypes.put((Object)name, (Object)typeAndValue.type_);
    }

    public Object getVariableValue(String name) {
        return this.variableValues.get((Object)name);
    }

    public Type getVariableType(String name) {
        return (Type)this.variableTypes.get((Object)name);
    }

    public SafeDynamic getVariableValueAndType(String name) {
        Type type = (Type)this.variableTypes.get((Object)name);
        if (type == null) {
            return null;
        }
        Object value = this.variableValues.get((Object)name);
        return new SafeDynamic(type, value);
    }

    public void removeVariable(String name) {
        this.variableValues.remove((Object)name);
        this.variableTypes.remove((Object)name);
    }

    public void removeVariables() {
        this.variableValues.clear();
        this.variableTypes.clear();
    }

    public Set<String> getVariables() {
        return this.variableTypes.keySet();
    }

    public ArrayList<CommandSessionImportEntry> getImportEntries() {
        return this.importEntries;
    }

    public void setImportEntries(ArrayList<CommandSessionImportEntry> importEntries) {
        this.importEntries = importEntries;
        this.updateRuntimeEnvironment(true);
    }

    public void runFromFile(String fileName, SCLReportingHandler handler) {
        try (LaxUTF8Reader reader = new LaxUTF8Reader(fileName);){
            this.execute(reader, handler);
        }
        catch (IOException e) {
            CommandSession.formatException(handler, e);
        }
    }

    public static CompilationError[] validate(ModuleRepository moduleRepository, StringReader commandReader) {
        CommandSession session = new CommandSession(moduleRepository, null);
        return session.validate(commandReader);
    }

    public static CompilationError[] validate(ModuleRepository moduleRepository, String command) {
        return CommandSession.validate(moduleRepository, new StringReader(command));
    }

    public CompilationError[] validate(String command) {
        return this.validate(new StringReader(command));
    }

    public void setDependenciesListener(UpdateListener dependenciesListener) {
        this.dependenciesListener = dependenciesListener;
    }

    private static class CancelExecution
    extends RuntimeException {
        private static final long serialVersionUID = -6925642906311538873L;

        private CancelExecution() {
        }
    }

    class CommandParser
    extends SCLParserImpl {
        SCLReportingHandler handler;
        MemoReader reader;
        EBlock currentBlock;

        public CommandParser(SCLReportingHandler handler, MemoReader reader) {
            super(reader);
            this.reader = reader;
            this.handler = handler;
        }

        void finishBlock() {
            if (this.currentBlock != null) {
                CommandSession.this.checkInterrupted();
                this.currentBlock.location = Locations.combine(this.currentBlock.getFirst().location, this.currentBlock.getLast().location);
                CommandSession.this.execute(this.reader, this.currentBlock, this.handler);
                this.currentBlock = null;
            }
        }

        @Override
        protected Object reduceStatementCommand() {
            Statement statement = (Statement)this.get(0);
            if (statement.mayBeRecursive()) {
                if (this.currentBlock == null) {
                    this.currentBlock = new EBlock();
                }
                this.currentBlock.addStatement(statement);
            } else {
                this.finishBlock();
                CommandSession.this.checkInterrupted();
                if (statement instanceof GuardStatement) {
                    CommandSession.this.execute(this.reader, ((GuardStatement)statement).value, this.handler);
                } else {
                    EBlock block = new EBlock();
                    block.addStatement(statement);
                    block.location = statement.location;
                    CommandSession.this.execute(this.reader, block, this.handler);
                }
            }
            return null;
        }

        @Override
        protected Object reduceImportCommand() {
            this.finishBlock();
            CommandSession.this.checkInterrupted();
            ImportDeclaration importDeclaration = (ImportDeclaration)this.get(0);
            this.handler.printCommand(this.reader.extractString(importDeclaration.location));
            new CommandSessionImportEntry(importDeclaration.moduleName, importDeclaration.localName).addTo(CommandSession.this.importEntries);
            CommandSession.this.updateRuntimeEnvironment(false);
            return null;
        }
    }

    private static class LocalFunction {
        final Function function;
        final Type type;

        public LocalFunction(Function function, Type type) {
            this.function = function;
            this.type = type;
        }
    }

    class PrintDecorator
    extends DelegatingSCLReportingHandler {
        public PrintDecorator(SCLReportingHandler baseHandler) {
            super(baseHandler);
        }

        public void print(String text) {
            super.print(text);
            if (CommandSession.this.fileOutput != null) {
                CommandSession.this.fileOutput.println(text);
            }
        }

        public void printCommand(String command) {
            super.printCommand(command);
            if (CommandSession.this.fileOutput != null) {
                CommandSession.this.fileOutput.println("> " + command);
            }
        }

        public void printError(String error) {
            super.printError(error);
            if (CommandSession.this.fileOutput != null) {
                CommandSession.this.fileOutput.println(error);
            }
        }
    }
}

