package org.simantics.scl.compiler.types.kinds;

import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

/**
 * KArrow represents a type kind that has a domain kind and a range kind. 
 */
public class KArrow extends Kind {
    public final Kind domain;
    public final Kind range;
    
    KArrow(Kind domain, Kind range) {
        this.domain = domain;
        this.range = range;
    }

    @Override
    protected void toString(TypeUnparsingContext tuc, StringBuilder b) {
        domain.toStringPar(tuc, b);
        b.append(" -> ");
        range.toString(tuc, b);
    }

    @Override
    public boolean contains(KMetaVar var) {
        return domain.contains(var) || range.contains(var);
    }
}
