package org.simantics.scl.compiler.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.RuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;

public class FileModuleSource extends EncodedTextualModuleSource {
    
    private final ClassLoader classLoader;
    private final File path;
    private final ImportDeclaration[] builtinImports;
   
    public FileModuleSource(String moduleName, ClassLoader classLoader,
            File path, ImportDeclaration[] builtinImports) {
        super(moduleName);
        this.classLoader = classLoader;
        this.path = path;
        this.builtinImports = builtinImports;
    }

    @Override
    protected InputStream getSourceStream(UpdateListener listener)
            throws IOException {
        return new FileInputStream(path);
    }

    @Override
    protected JavaReferenceValidator<?, ?, ?, ?> getJavaReferenceValidator() {
        return new RuntimeJavaReferenceValidator(classLoader);
    }
    
    @Override
    public ImportDeclaration[] getBuiltinImports(UpdateListener listener) {
        return builtinImports;
    }
}
