package org.simantics.scl.compiler.internal.parsing.documentation;

public class ListItem extends DocumentationElement {

    String level;
    String text;
    
    public ListItem(String line) {
        int i;
        for(i=0;i<line.length();++i) {
            char c = line.charAt(i);
            if(c != '*' && c != '#')
                break;
        }
        this.level = line.substring(0, i);
        this.text = line.substring(i).trim();
    }

    @Override
    public void toHtml(HtmlUnparsingContext context) {
        context.setListLevel(level);
        context.getStringBuilder().append("<li>").append(text).append("</li>\n");        
    }

}
