package org.simantics.scl.compiler.internal.codegen.ssa;

import java.util.ArrayList;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ClosureBinder;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Printable;
import org.simantics.scl.compiler.internal.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public abstract class SSAClosure implements Printable, BoundVarBinder {
    Val target;
    
    ClosureBinder parent;
    SSAClosure prev;
    SSAClosure next;
    
    public void setParent(ClosureBinder parent) {
        this.parent = parent;
    }

    public SSAClosure getNext() {
        return next;
    }

    public void setPrev(SSAClosure function) {
        this.prev = function;
    }

    public void setNext(SSAClosure function) {
        this.next = function;
    }

    public SSAFunction getParentFunction() {
        return parent.getParentFunction();
    }
    
    public ClosureBinder getParent() {
        return parent;
    }

    public Val getTarget() {
        return target;
    }
    
    public void setTarget(Val target) {
        this.target = target;
        if(target instanceof BoundVar)
            ((BoundVar) target).parent = this;             
    }
    
    public void setTarget(BoundVar target) {
        this.target = target;
        target.parent = this;             
    }
    
    public void detach() {
        if(prev == null)
            parent.setFirstClosure(next);
        else
            prev.next = next;
        if(next != null)
            next.prev = prev;
    }
    
    public void remove() {
        destroy();
        detach();
    }

    public SSAClosure copy() {
        return copy(new CopyContext());
    }
    
    public abstract void destroy();
    public abstract SSAClosure copy(CopyContext context);
    public abstract void markGenerateOnFly();
    public abstract void replace(TVar[] vars, Type[] replacements);
    public abstract void collectFreeVariables(ArrayList<ValRef> freeVars);
    public abstract void simplify(SSASimplificationContext context);
    public abstract void validate(SSAValidationContext context);
    public abstract void lambdaLift(SSALambdaLiftingContext context);
    public abstract boolean isValue();
    public abstract Type getType();
    public abstract void parametrize(BoundVar[] parameters);

    public Constant liftClosure(BoundVar newTarget, BoundVar[] newVarsList) {
        throw new InternalCompilerError("Unsupported method liftClosure");
    }

    public void generateCode(ModuleBuilder moduleBuilder) {
        throw new InternalCompilerError("Unsupported method generateCode");
    }

    public abstract void forValRefs(ValRefVisitor visitor);

    public abstract void cleanup();
    
}
