package org.simantics.scl.compiler.internal.codegen.references;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ValSpecialization implements IVal {

    Val val;
    Type[] parameters;
    
    public ValSpecialization(Val val, Type ... parameters) {
        this.val = val;
        this.parameters = parameters;
    }

    @Override
    public Type getType() {
        return Types.instantiate(val.getType(), parameters); 
    }

    @Override
    public ValRef createOccurrence() {
        return val.createOccurrence(parameters);
    }

    @Override
    public IVal createSpecialization(Type... parameters) {
        return new ValSpecialization(val, Types.concat(this.parameters, parameters));
    }

    @Override
    public void push(MethodBuilder mb) {
        throw new InternalCompilerError();
    }

    @Override
    public ValRef createOccurrence(Type... parameters) {
        return val.createOccurrence(Types.concat(this.parameters, parameters));
    }

    @Override
    public Type apply(MethodBuilder mb, Type[] typeParameters,
            Val... parameters) {
        throw new InternalCompilerError();
    }

    @Override
    public Object realizeValue(TransientClassBuilder classLoader) {
        return val.realizeValue(classLoader);
    }

    @Override
    public void setLabel(String label) {        
    }

}
