package org.simantics.scl.compiler.internal.codegen.references;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.map.hash.THashMap;

public final class BoundVar extends Val {
    public BoundVarBinder parent;
    Type type;
    String label;
    
    /**
     * This means that the bound var does not need a local variable
     * but it can be generated into stack when needed.
     */
    public boolean generateOnFly;
    
    public BoundVar(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return type;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        if(generateOnFly)
            ((LetApply)parent).push(mb);
        else if(!mb.getJavaTypeTranslator().toTypeDesc(type).equals(TypeDesc.VOID))
            mb.loadLocal(mb.getLocalVariable(this));        
    }

    public BoundVar copy(THashMap<TVar, TVar> tvarMap) {
        return new BoundVar(type.replace(tvarMap));
    }

    public void replace(TVar[] vars, Type[] replacements) {
        type = type.replace(vars, replacements);
    }

    public SSAFunction getFunctionParent() {
        return parent.getParentFunction();
    }

    public static BoundVar[] concat(BoundVar[] a, BoundVar[] b) {
        BoundVar[] result = new BoundVar[a.length + b.length];
        int l = a.length;
        for(int i=0;i<l;++i)
            result[i] = a[i];
        for(int i=0;i<b.length;++i)
            result[i+l] = b[i];
        return result;
    }

    public BoundVarBinder getParent() {
        return parent;
    }
    
    @Override
    public int getEffectiveArity() {
        if(parent instanceof SSAFunction) {
            SSAFunction function = (SSAFunction)parent;
            int arity = function.getArity();
            if(function.hasEffect())
                ++arity;
            return arity;
        }
        else
            return 0;
    }
    
    @Override
    public Object realizeValue(TransientClassBuilder classLoader) {
        throw new UnsupportedOperationException();
    }

    public static BoundVar[] copy(BoundVar[] vars) {
        BoundVar[] result = new BoundVar[vars.length];
        for(int i=0;i<vars.length;++i)
            result[i] = new BoundVar(vars[i].getType());
        return result;
    }
    
    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }
}
