package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public class GuardedExpression extends Symbol {
    public Expression[] guards;
    public Expression value;
    
    public GuardedExpression(Expression[] guards, Expression value) {
        this.guards = guards;
        this.value = value;
    }

    public GuardedExpression replace(ReplaceContext context) {
        return new GuardedExpression(
                Expression.replace(context, guards), 
                value.replace(context));
    }

    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(Expression guard : guards)
                guard.setLocationDeep(loc);
            value.setLocationDeep(loc);
        }
    }
}
