package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public abstract class DecoratingExpression extends SimplifiableExpression {
    public Expression expression;
    
    public DecoratingExpression(long loc, Expression expression) {
        super(loc);
        this.expression = expression;
    }

    @Override
    protected void updateType() throws MatchException {
        setType(expression.getType());        
    }
    
    @Override
    public Expression simplify(SimplificationContext context) {
        expression = expression.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        expression = expression.resolve(context);
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        expression = expression.resolveAsPattern(context);
        return this;
    }
    
    @Override
    public EVar getPatternHead() throws NotPatternException {
        return expression.getPatternHead();
    }
    
    @Override
    public LhsType getLhsType() throws NotPatternException {
        return expression.getLhsType();
    }
    
    @Override
    public void getParameters(TranslationContext translationContext,
            ArrayList<Expression> parameters) {
        expression.getParameters(translationContext, parameters);
    }

    @Override
    public int getFunctionDefinitionPatternArity() throws NotPatternException {
        return expression.getFunctionDefinitionPatternArity();
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            expression.setLocationDeep(loc);
        }
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        throw new InternalCompilerError("Cannot generate code for " + getClass().getSimpleName() + ".");
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        expression = expression.inferType(context);
        return this;
    }
    
    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        expression = expression.checkBasicType(context, requiredType);
        return this;
    }
    
    @Override
    public Expression checkIgnoredType(TypingContext context) {
        expression = expression.checkIgnoredType(context);
        return this;
    }
    
    @Override
    public int getSyntacticFunctionArity() {
        return expression.getSyntacticFunctionArity();
    }
}
