package org.simantics.scl.commands;

import java.util.concurrent.ConcurrentHashMap;

import org.simantics.db.ReadGraph;
import org.simantics.scl.commands.internal.CommandImpl;


public class Commands {
    private static final ConcurrentHashMap<String, Command> COMMAND_CACHE = 
            new ConcurrentHashMap<String, Command>();

    /**
     * Returns a command object of given type. This method always succeeds,
     * but may return a command object whose check-method always returns fail
     * and commit will throw an exception.
     */
    public static Command get(ReadGraph graph, String name) {
        Command command = COMMAND_CACHE.get(name);
        if(command == null) {
            command = CommandImpl.create(graph, name);
            COMMAND_CACHE.put(name, command);
        }
        return command;
    }
}
