/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;

public class CompoundStroke
implements Stroke {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int INTERSECT = 2;
    public static final int DIFFERENCE = 3;
    private final Stroke stroke1;
    private final Stroke stroke2;
    private final int operation;

    public CompoundStroke(Stroke stroke1, Stroke stroke2, int operation) {
        this.stroke1 = stroke1;
        this.stroke2 = stroke2;
        this.operation = operation;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        Area area1 = new Area(this.stroke1.createStrokedShape(shape));
        Area area2 = new Area(this.stroke2.createStrokedShape(shape));
        switch (this.operation) {
            case 0: {
                area1.add(area2);
                break;
            }
            case 1: {
                area1.subtract(area2);
                break;
            }
            case 2: {
                area1.intersect(area2);
                break;
            }
            case 3: {
                area1.exclusiveOr(area2);
            }
        }
        return area1;
    }
}

