/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes.connection;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.scenegraph.g2d.nodes.connection.ActionShapes;
import org.simantics.scenegraph.utils.Quality;
import org.simantics.scenegraph.utils.QualityHints;

public class HighlightActionPointsAction
implements IAction {
    private static final Shape CROSS_SHAPE = ActionShapes.CROSS_SHAPE;
    private static final Shape SCISSOR_SHAPE = ActionShapes.transformShape(ActionShapes.SCISSOR_SHAPE, 1.0, 1.0, 0.0, 0.0, -1.5707963267948966);
    private static final Color CROSS_COLOR = new Color(228, 64, 97);
    private static final Color SCISSOR_COLOR = new Color(20, 20, 20);
    public static final Stroke STROKE = new BasicStroke(0.1f, 1, 1);
    public static final AlphaComposite NO_HIT_COMPOSITE = AlphaComposite.SrcOver.derive(0.8f);
    public static final AlphaComposite HIT_COMPOSITE = AlphaComposite.SrcOver.derive(0.2f);
    public static final double DEGENERATED_LINE_LENGTH = 1.0;
    public static final double CUT_DIST_FROM_END = 0.75;
    RouteGraph rg;
    transient Collection<RouteLineHalf> lhs = new ArrayList<RouteLineHalf>();
    transient AffineTransform transform = new AffineTransform();
    transient Rectangle2D rect = new Rectangle2D.Double();
    transient Point2D point = new Point2D.Double();

    public HighlightActionPointsAction(RouteGraph rg) {
        this.rg = rg;
    }

    public void setRouteGraph(RouteGraph rg) {
        this.rg = rg;
    }

    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        boolean hit;
        boolean branchedConnection;
        boolean simpleConnection = this.rg.isSimpleConnection() || this.rg.getTerminals().size() <= 2;
        boolean bl = branchedConnection = this.rg.getTerminals().size() > 2;
        if (!branchedConnection || simpleConnection) {
            return;
        }
        AffineTransform preTr = g.getTransform();
        double realViewScale = 1.0 / HighlightActionPointsAction.getScale(preTr);
        if (realViewScale > 0.7) {
            return;
        }
        this.lhs.clear();
        this.rg.getLineHalves(this.lhs);
        Pick pick = this.pickAction(this.rg, this.lhs, preTr, mouseX, mouseY);
        Composite originalComposite = g.getComposite();
        AlphaComposite basicComposite = pick.action != null ? HIT_COMPOSITE : NO_HIT_COMPOSITE;
        g.setComposite(basicComposite);
        QualityHints origQualityHints = QualityHints.getQuality(g);
        QualityHints.getHints(Quality.HIGH).setQuality(g);
        if (!simpleConnection) {
            g.setPaint(CROSS_COLOR);
            for (RouteLineHalf lh : this.lhs) {
                if (HighlightActionPointsAction.removeLocation(lh, this.point) == null) continue;
                hit = pick.matches(Action.REMOVE, lh);
                if (hit) {
                    g.setComposite(originalComposite);
                }
                g.translate(this.point.getX(), this.point.getY());
                g.fill(CROSS_SHAPE);
                g.setTransform(preTr);
                if (!hit) continue;
                g.setComposite(basicComposite);
            }
        }
        if (branchedConnection) {
            g.setPaint(SCISSOR_COLOR);
            for (RouteLineHalf lh : this.lhs) {
                if (HighlightActionPointsAction.reconnectLocation(lh, this.point) == null) continue;
                hit = pick.matches(Action.RECONNECT, lh);
                if (hit) {
                    g.setComposite(originalComposite);
                }
                this.transform.setToTranslation(this.point.getX(), this.point.getY());
                if (!lh.getLine().isHorizontal()) {
                    this.transform.rotate(1.5707963267948966);
                }
                this.transform.translate(0.0, 0.35);
                g.transform(this.transform);
                g.fill(SCISSOR_SHAPE);
                g.setTransform(preTr);
                if (!hit) continue;
                g.setComposite(basicComposite);
            }
        }
        origQualityHints.setQuality(g);
        g.setComposite(originalComposite);
    }

    public Pick pickAction(RouteGraph rg, AffineTransform viewTr, double mouseX, double mouseY) {
        boolean simpleConnection;
        boolean branchedConnection = rg.getTerminals().size() > 2;
        boolean bl = simpleConnection = rg.isSimpleConnection() || rg.getTerminals().size() <= 2;
        if (!branchedConnection || simpleConnection) {
            return null;
        }
        this.lhs.clear();
        return this.pickAction(rg, rg.getLineHalves(this.lhs), viewTr, mouseX, mouseY);
    }

    public Pick pickAction(RouteGraph rg, Collection<RouteLineHalf> lhs, AffineTransform viewTr, double mouseX, double mouseY) {
        boolean simpleConnection;
        boolean branchedConnection = rg.getTerminals().size() > 2;
        boolean bl = simpleConnection = rg.isSimpleConnection() || rg.getTerminals().size() <= 2;
        if (!branchedConnection || simpleConnection || viewTr == null) {
            return Pick.MISS;
        }
        double viewScale = 1.0 / HighlightActionPointsAction.getScale(viewTr);
        if (viewScale > 0.7) {
            return Pick.MISS;
        }
        double nearest = Double.MAX_VALUE;
        RouteLineHalf selected = null;
        Action selectedAction = null;
        if (!simpleConnection) {
            double s = ActionShapes.CROSS_WIDTH * 0.25;
            for (RouteLineHalf lh : lhs) {
                double distSq;
                if (HighlightActionPointsAction.removeLocation(lh, this.point) == null) continue;
                double x = this.point.getX();
                double y = this.point.getY();
                this.rect.setFrameFromCenter(x, y, x - s, y - s);
                boolean hit = this.rect.contains(mouseX, mouseY);
                if (!hit || !((distSq = HighlightActionPointsAction.distSq(x, y, mouseX, mouseY)) < nearest)) continue;
                nearest = distSq;
                selected = lh;
                selectedAction = Action.REMOVE;
            }
        }
        if (branchedConnection) {
            double w = ActionShapes.SCISSOR_HEIGHT * 0.4;
            double h = ActionShapes.SCISSOR_WIDTH * 0.3;
            for (RouteLineHalf lh : lhs) {
                double distSq;
                if (HighlightActionPointsAction.reconnectLocation(lh, this.point) == null) continue;
                double x = this.point.getX();
                double y = this.point.getY();
                this.rect.setFrameFromCenter(x, y, x - w, y - h);
                boolean hit = this.rect.contains(mouseX, mouseY);
                if (!hit || !((distSq = HighlightActionPointsAction.distSq(x, y, mouseX, mouseY)) < nearest)) continue;
                nearest = distSq;
                selected = lh;
                selectedAction = Action.RECONNECT;
            }
        }
        return selected == null ? Pick.MISS : new Pick(selectedAction, selected);
    }

    private static Point2D removeLocation(RouteLineHalf lh, Point2D p) {
        if (lh.getLine().getTerminal() == null) {
            return null;
        }
        double x = lh.getLink().getX();
        double y = lh.getLink().getY();
        if (lh.getLine().isHorizontal()) {
            x = (lh.getLine().getBegin().getX() + lh.getLine().getEnd().getX()) * 0.5;
        } else {
            y = (lh.getLine().getBegin().getY() + lh.getLine().getEnd().getY()) * 0.5;
        }
        p.setLocation(x, y);
        return p;
    }

    private static Point2D reconnectLocation(RouteLineHalf lh, Point2D p) {
        if (lh.getLine().getLength() < 3.0) {
            return null;
        }
        double x = lh.getLink().getX();
        double y = lh.getLink().getY();
        if (lh.getLine().isHorizontal()) {
            x = lh.getLink() == lh.getLine().getBegin() ? (x += 1.5) : (x -= 1.5);
        } else {
            y = lh.getLink() == lh.getLine().getBegin() ? (y += 1.5) : (y -= 1.5);
        }
        p.setLocation(x, y);
        return p;
    }

    private static double distSq(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    private static double getScale(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        return Math.sqrt(Math.abs(m00 * m11 - m10 * m01));
    }

    public static enum Action {
        REMOVE,
        RECONNECT;

    }

    public static class Pick {
        public static final Pick MISS = new Pick(null, null);
        Action action;
        RouteLineHalf line;

        public Pick(Action action, RouteLineHalf line) {
            this.action = action;
            this.line = line;
        }

        public boolean hasAction(Action action) {
            return this.action == action;
        }

        public boolean hasResult() {
            return this.action != null && this.line != null;
        }

        public boolean matches(Action action, RouteLineHalf line) {
            if (this.action == null || this.line == null) {
                return false;
            }
            return this.action.equals((Object)action) && this.line.equals(line);
        }
    }
}

