/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.NodeUtil;

public class BranchPointNode
extends G2DNode {
    private static final long serialVersionUID = -5838113741617205901L;
    public static final Shape SHAPE = new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0);
    public static final Shape SHAPE2 = new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0);
    public static final Stroke STROKE = new BasicStroke(0.1f, 0, 0);
    Integer degree = 0;
    Byte direction = 0;

    @INode.SyncField(value={"degree"})
    public void setDegree(int degree) {
        this.degree = degree;
    }

    @INode.SyncField(value={"direction"})
    public void setDirection(byte direction) {
        this.direction = direction;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform oldTransform = g.getTransform();
        if (this.transform != null) {
            g.transform(this.transform);
        }
        try {
            this.renderBranchpoint(g);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    private void renderBranchpoint(Graphics2D g) {
        boolean selected = NodeUtil.isSelected(this, 2);
        if (this.degree <= 2) {
            if (selected) {
                g.setPaint(Color.GREEN);
                g.fill(SHAPE2);
                g.setPaint(Color.BLACK);
                g.setStroke(STROKE);
                g.draw(SHAPE2);
            } else {
                g.setPaint(Color.LIGHT_GRAY);
                g.fill(SHAPE2);
            }
        } else if (selected) {
            g.setPaint(Color.GREEN);
            g.fill(SHAPE);
            g.setPaint(Color.BLACK);
            g.setStroke(STROKE);
            g.draw(SHAPE);
        } else {
            g.setPaint(Color.BLACK);
            g.fill(SHAPE);
        }
        if (this.direction != 0) {
            g.setStroke(STROKE);
            g.setColor(this.degree <= 2 ? Color.BLACK : (selected ? Color.BLACK : Color.GREEN));
            if (this.direction == 1) {
                g.draw(new Line2D.Double(-0.5, 0.0, 0.5, 0.0));
            } else if (this.direction == 2) {
                g.draw(new Line2D.Double(0.0, -0.5, 0.0, 0.5));
            }
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [degree=" + this.degree + "]";
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        Shape shp = SHAPE;
        if (this.degree <= 2) {
            shp = SHAPE2;
        }
        return shp.getBounds2D();
    }
}

