/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.JComponentSG;
import org.simantics.scenegraph.swing.JComponentUtils;
import org.simantics.scenegraph.swing.JViewportSG;

public class JScrollPaneSG
extends JScrollPane
implements JComponentSG {
    private static final long serialVersionUID = 1941565557888406721L;
    private final INode node;

    public JScrollPaneSG(Component view, INode node) {
        this.node = node;
        this.setLayout(new ScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
        this.setViewport(this.createViewport());
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        if (view != null) {
            this.setViewportView(view);
        }
        this.setOpaque(true);
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new ScrollBarSG(1);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new ScrollBarSG(0);
    }

    @Override
    public boolean contains(int eventX, int eventY) {
        return JComponentUtils.contains(eventX, eventY, this, this.node);
    }

    @Override
    public boolean containsTransformed(Point p) {
        return super.contains(p.x, p.y);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    protected JViewport createViewport() {
        return new JViewportSG(this.node);
    }

    class ScrollBarSG
    extends JScrollPane.ScrollBar
    implements JComponentSG {
        private static final long serialVersionUID = 209426441282352819L;

        ScrollBarSG(int flags) {
            super(JScrollPaneSG.this, flags);
        }

        @Override
        public boolean contains(int eventX, int eventY) {
            return JComponentUtils.contains(eventX, eventY, this, JScrollPaneSG.this.node);
        }

        @Override
        public boolean containsTransformed(Point p) {
            return super.contains(p.x, p.y);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        protected void processEvent(AWTEvent e) {
            super.processEvent(JComponentUtils.relocate(e, this, JScrollPaneSG.this.node));
        }
    }
}

