/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.SGMouseEvent;
import org.simantics.scenegraph.g2d.events.SGMouseWheelEvent;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.swing.JComponentSG;

public class JComponentUtils {
    private static int getAbsoluteX(Component c, int init) {
        if (c instanceof ComponentNode.ComponentContainer) {
            return init;
        }
        return JComponentUtils.getAbsoluteX(c.getParent(), init + c.getX());
    }

    private static int getAbsoluteY(Component c, int init) {
        if (c instanceof ComponentNode.ComponentContainer) {
            return init;
        }
        return JComponentUtils.getAbsoluteY(c.getParent(), init + c.getY());
    }

    private static Point transform(int eventX, int eventY, JComponentSG comp, INode node) {
        if (node == null) {
            return null;
        }
        G2DSceneGraph sg = (G2DSceneGraph)node.getRootNode();
        AWTChassis chassis = (AWTChassis)sg.getRootPane().getParent();
        int trX = JComponentUtils.getAbsoluteX(comp.getComponent(), 0);
        int trY = JComponentUtils.getAbsoluteY(comp.getComponent(), 0);
        AffineTransform ct = (AffineTransform)chassis.getCanvasContext().getDefaultHintContext().getHint(Hints.KEY_CANVAS_TRANSFORM);
        if (ct == null) {
            return null;
        }
        eventX += trX;
        eventX = (int)((double)eventX - ct.getTranslateX());
        eventX = (int)((double)eventX / ct.getScaleX());
        eventY += trY;
        eventY = (int)((double)eventY - ct.getTranslateY());
        eventY = (int)((double)eventY / ct.getScaleY());
        return new Point(eventX -= trX, eventY -= trY);
    }

    public static boolean contains(int eventX, int eventY, JComponentSG comp, INode node) {
        Point transformed = JComponentUtils.transform(eventX, eventY, comp, node);
        if (transformed == null) {
            return comp.containsTransformed(new Point(eventX, eventY));
        }
        boolean result = comp.containsTransformed(transformed);
        return result;
    }

    public static AWTEvent relocate(AWTEvent e, JComponentSG comp, INode node) {
        if (node == null) {
            return e;
        }
        if (!(e instanceof MouseEvent)) {
            return e;
        }
        MouseEvent me = (MouseEvent)e;
        Point transformed = JComponentUtils.transform(me.getX(), me.getY(), comp, node);
        if (transformed == null) {
            return e;
        }
        if (me.getID() == 507) {
            return new SGMouseWheelEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), transformed.x, transformed.y, me.getClickCount(), me.isPopupTrigger(), ((MouseWheelEvent)me).getScrollType(), ((MouseWheelEvent)me).getScrollAmount(), ((MouseWheelEvent)me).getWheelRotation(), me);
        }
        return new SGMouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), transformed.x, transformed.y, me.getClickCount(), me.isPopupTrigger(), me.getButton(), me);
    }
}

