/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.example;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.VolatileImage;
import javax.swing.JComponent;
import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DSceneGraph;

public class SGCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = -7835590396125816119L;
    private G2DSceneGraph scenegraph = null;
    private VolatileImage buffer = null;

    public SGCanvas() {
        this.setFocusable(true);
    }

    public void initListeners() {
        this.addKeyListener(this);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.scenegraph == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle b = this.getBounds();
        int newWidth = b.width;
        int newHeight = b.height;
        if (this.buffer == null) {
            this.buffer = this.createVolatileImage(newWidth, newHeight);
        } else {
            int w = this.buffer.getWidth();
            int h = this.buffer.getHeight();
            if (w != newWidth || h != newHeight) {
                this.buffer = this.createVolatileImage(newWidth, newHeight);
            } else {
                int valid = this.buffer.validate(g2d.getDeviceConfiguration());
                if (valid == 2) {
                    this.buffer = this.createVolatileImage(newWidth, newHeight);
                }
            }
        }
        Graphics2D bg = (Graphics2D)this.buffer.getGraphics();
        bg.setClip((int)b.getMinX(), (int)b.getMinY(), (int)b.getWidth(), (int)b.getHeight());
        this.scenegraph.render(bg);
        g2d.drawImage(this.buffer, 0, 0, null);
    }

    public void setSceneGraph(G2DSceneGraph scenegraph) {
        this.scenegraph = scenegraph;
        scenegraph.setRootPane((JComponent)this);
    }

    public G2DSceneGraph getSceneGraph() {
        return this.scenegraph;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseWheelMoved(event);
            this.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().keyPressed(event);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().keyReleased(event);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().keyTyped(event);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().focusGained(event);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().focusLost(event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseClicked(event);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseExited(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.scenegraph != null) {
            G2DFocusManager.INSTANCE.clearFocus();
            this.scenegraph.getEventDelegator().mousePressed(event);
            if (G2DFocusManager.INSTANCE.getFocusOwner() == null) {
                this.requestFocusInWindow();
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseReleased(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseDragged(event);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.scenegraph != null) {
            this.scenegraph.getEventDelegator().mouseMoved(event);
        }
    }
}

