package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Point;

import javax.swing.JComponent;
import javax.swing.JList;

import org.simantics.scenegraph.INode;

public class JListSG extends JList implements JComponentSG {

	private static final long serialVersionUID = 3883052650752301256L;
	
	final private INode node;

	JListSG(INode node) {
		this.node = node;
	}
	
	@Override
	public boolean contains(int eventX, int eventY) {
		return JComponentUtils.contains(eventX, eventY, this, node);
	}
	
	@Override
	public boolean containsTransformed(Point p) {
		return super.contains(p.x, p.y);
	}
	
	@Override
	public JComponent getComponent() {
		return this;
	}
	
	@Override
	protected void processEvent(AWTEvent e) {
		super.processEvent(JComponentUtils.relocate(e, this, node));
	}
	
}
