/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.example;

import javax.swing.RepaintManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.UIManager.LookAndFeelInfo;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.swing.SliderNode;

public class G2DLocalView extends ViewPart {
	SGComponent c;
	
	protected boolean rotate = true;
	protected TransformNode transform = null;
	protected TransformNode transform2 = null;
	protected SliderNode sn1 = null;
	protected SliderNode sn2 = null;
	protected SampleThread t = new SampleThread() {
		public void repaint() {
			if(c != null) {
				RepaintManager rm = RepaintManager.currentManager(c.getCanvas());
				rm.markCompletelyDirty(c.getCanvas());
			}
		}
	};

	@Override
	public void createPartControl(Composite parent) {
		try {
		    for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
		        if ("Nimbus".equals(info.getName())) {
		            UIManager.setLookAndFeel(info.getClassName());
		            break;
		        }
		    }
		} catch (UnsupportedLookAndFeelException e) {
		    // handle exception
		} catch (ClassNotFoundException e) {
		    // handle exception
		} catch (InstantiationException e) {
		    // handle exception
		} catch (IllegalAccessException e) {
		    // handle exception
		}
		
	    c = new SGComponent(parent, 0);
	    c.syncPopulate();
	    
		c.addDisposeListener(new DisposeListener(){
			@Override
			public void widgetDisposed(DisposeEvent e) {
				t.stop();
			}});
		
	    c.getCanvas().setSceneGraph(t.sg);
	    
	    c.initListeners();

		t.start();
	}
	
	@Override
	public void setFocus() {
		c.setFocus();
	}
	
}
