/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;

public class TransformNode extends G2DParentNode {

    private static final long serialVersionUID = -3722167807691239528L;

    @SyncField("transform")
    public void rotate(double theta) {
        if (transform == IdentityAffineTransform.INSTANCE)
            transform = AffineTransform.getRotateInstance(theta);
        else
            transform.rotate(theta);
    }

    @SyncField("transform")
    public void translate(double x, double y) {
        if (transform == IdentityAffineTransform.INSTANCE)
            transform = AffineTransform.getTranslateInstance(x, y);
        else
            transform.translate(x, y);
    }

    @SyncField("transform")
    public void scale(double x, double y) {
        if (transform == IdentityAffineTransform.INSTANCE)
            transform = AffineTransform.getScaleInstance(x, y);
        else
            transform.scale(x, y);
    }

    @Override
    public void render(Graphics2D g2d) {
        super.render(g2d);
    }

    @Override
    public String toString() {
        return super.toString();
    }

}
