/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events.adapter;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.FocusEvent.FocusGainedEvent;
import org.simantics.scenegraph.g2d.events.FocusEvent.FocusLostEvent;

/**
 * Adapts AWT focus event to G2D event
 * 
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class AWTFocusAdapter extends AbstractEventAdapter implements FocusListener {

    public AWTFocusAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public AWTFocusAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    @Override
    public void focusGained(FocusEvent e) {
        handleEvent(new FocusGainedEvent(sender, System.currentTimeMillis()));
    }

    @Override
    public void focusLost(FocusEvent e) {
        handleEvent(new FocusLostEvent(sender, System.currentTimeMillis()));
    }

}
