/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;

public class BundleInfo
implements Comparable<BundleInfo>,
IVersionedId {
    public IVersionedId vid;
    public String name;
    public String description;

    public static BundleInfo read(IInstallableUnit iu) {
        String name = iu.getProperty("org.eclipse.equinox.p2.name");
        String description = iu.getProperty("org.eclipse.equinox.p2.description");
        return new BundleInfo((IVersionedId)iu, name, description);
    }

    public BundleInfo(String id, String version, String name, String description) {
        this.vid = new VersionedId(id, version);
        this.name = name;
        this.description = description;
    }

    public BundleInfo(IVersionedId vid, String name, String description) {
        this.vid = vid;
        this.name = name;
        this.description = description;
    }

    public String toString() {
        return this.name;
    }

    public String toVersionString() {
        return Version.emptyVersion.equals(this.vid.getVersion()) ? this.vid.getId() : String.valueOf(this.vid.getId()) + '/' + this.vid.getVersion().toString();
    }

    @Override
    public int compareTo(BundleInfo o) {
        return this.name.compareTo(o.name);
    }

    public String getId() {
        return this.vid.getId();
    }

    public void setId(IVersionedId vid) {
        this.vid = vid;
    }

    public Version getVersion() {
        return this.vid.getVersion();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.vid.hashCode();
    }

    public boolean equals(Object obj) {
        return this.vid.equals(obj);
    }
}

