/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.adapters;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleAdapter;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.project.IProject;
import org.simantics.project.ProjectFeatures;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.IProjectFeature;
import org.simantics.project.features.registry.IProjectFeatureExtension;
import org.simantics.project.impl.Project;
import org.simantics.project.ontology.ProjectResource;

public class ProjectAdapter
extends SimpleAdapter<IProject> {
    public IProject adapt(ReadGraph g, Resource resource) throws DatabaseException {
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(resource, PROJ.Project)) {
            throw new ValidationException("Cannot adapt resource " + NameUtils.getSafeName((ReadGraph)g, (Resource)resource) + " to IProject. Resource is not an instance of " + "http://www.simantics.org/Project-1.2/Project");
        }
        Project p = new Project(g.getSession(), resource);
        try {
            Collection<IProjectFeatureExtension> sorted = ProjectFeatures.getTopologicallySortedFeatures(g, p.get());
            this.loadFeatures(g, p, sorted);
            return p;
        }
        catch (ProjectException e) {
            throw new ValidationException("project feature loading failed", (Throwable)e);
        }
    }

    private void loadFeatures(ReadGraph g, Project p, Collection<IProjectFeatureExtension> sortedFeatures) throws ProjectException, ValidationException, ServiceException {
        for (IProjectFeatureExtension feature : sortedFeatures) {
            try {
                IProjectFeature pf = feature.newInstance();
                p.addFeature(pf);
            }
            catch (CoreException e) {
                throw new ValidationException((Throwable)e);
            }
        }
    }
}

