/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.io.File;
import java.net.URI;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.simantics.project.internal.Activator;
import org.simantics.utils.strings.EString;

/**
 * This utility class contains methods for handling bundles in SPM application.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class SPMUtil {

	private static IProvisioningAgent localAgent;
	private static File workspacesLocation;
	private static File coresLocation;

	/**
	 * Get bundle repository location in Simantics Project Management workspace.
	 *
	 * @return Bundle repository location
	 */
	public static URI getRepositoryLocation() {
		return Platform.getLocation().append("repository").toFile().toURI();
	}

	/**
	 * Create provisioning agent that handles local bundle repository.
	 *
	 * @return
	 * @throws ProvisionException
	 * @throws Exception
	 */
	public synchronized static IProvisioningAgent getLocalAgent() throws ProvisionException {
		if (localAgent == null) {
			IPath agentLocation = Platform.getLocation().append("P2");
			localAgent = P2Util.createAgent( agentLocation );
		}
		return localAgent;
	}




	public static String[] getSourceLocations() {
		IScopeContext[] scopes = new IScopeContext[] { InstanceScope.INSTANCE, DefaultScope.INSTANCE };
		String yyy = Platform.getPreferencesService().getString(Activator.PLUGIN_ID, RepositoryPreference.P_REPOSITY_SOURCES, "", scopes);
		return EString.explode(yyy, "\n");
	}

	/**
	 * Get diretory that contains project workspaces
	 *
	 * @return
	 */
	public synchronized static File getWorkspacesLocation() {
		if (workspacesLocation == null) {
			workspacesLocation = new File( Platform.getLocation().toFile(), "workspaces" );
		}
		return workspacesLocation;
	}

	/**
	 * Get diretory that contains cores
	 *
	 * @return
	 */
	public synchronized static File getCoresLocation() {
		if (coresLocation == null) {
			coresLocation = new File( Platform.getLocation().toFile(), "cores" );
		}
		return coresLocation;
	}

	public static boolean isWorkspace(File path) {
		if (!path.exists()) return false;
		File db = new File(path, "db");
		if (!db.exists()) return false;
//		if (!isDatabase(db)) return false;
//		File p2 = new File(path, "p2");
//		if (!p2.exists()) return false;
		File props = new File(path, "simantics.cfg");
		if (!props.exists()) return false;
		return true;
	}

//	public static boolean isDatabase(File path) {
//		File config = new File(path, ProCoreConfigFile);
//		return config.exists();
//	}


}

