/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import java.util.HashSet;
import java.util.Set;

/**
 * Planner analyses how to install a database
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class Planner {

	BundlePool pool;
	
	/** Specs that are invalid */
	Set<DatabaseSpec> nonworking = new HashSet<DatabaseSpec>();
	
	/** Solutoin specs */
	Set<DatabaseSpec> working = new HashSet<DatabaseSpec>();
	
	/** Branched specs that are queued to be tested for validity or to be modified */
	Set<DatabaseSpec> queued = new HashSet<DatabaseSpec>();
	
	/**
	 * Plan install actions from one specification to another. 
	 * 
	 * @param from
	 * @param to
	 * @param advisor
	 * @return fixed install plan
	 */
//	public DatabaseSpec fixSpecification(DatabaseSpec src, DatabaseSpec dst, InstallAdvisor advisor) {
//		
//	}
	
	
	
	
}

//interface InstallAdvisor {
//	
//	public enum OntologyAction { UpgradeProjects, Downgrade 
//	
//	// Ontology upgrade
//	
//}

