/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.core.DefaultAgentProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@SuppressWarnings("restriction")
public class P2Util {
	
//	private static void initializeServices() throws CoreException {
//		BundleContext context = Activator.getContext();
//		packageAdminRef = context.getServiceReference(PackageAdmin.class.getName());
//		packageAdmin = (PackageAdmin) context.getService(packageAdminRef);
//		ServiceReference agentProviderRef = context.getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
//		IProvisioningAgentProvider provider = (IProvisioningAgentProvider) context.getService(agentProviderRef);
//		URI p2DataArea;
//		if (destination != null || sharedLocation != null) {
//			File dataAreaFile = sharedLocation == null ? new File(destination, "p2") : sharedLocation;//$NON-NLS-1$
//			p2DataArea = dataAreaFile.toURI();
//		} else {
//			p2DataArea = null;
//		}
//		targetAgent = provider.createAgent(p2DataArea);
//		targetAgent.registerService(IProvisioningAgent.INSTALLER_AGENT, provider.createAgent(null));
//
//		context.ungetService(agentProviderRef);
//		if (profileId == null) {
//			if (destination != null) {
//				File configIni = new File(destination, "configuration/config.ini"); //$NON-NLS-1$
//				InputStream in = null;
//				try {
//					Properties ciProps = new Properties();
//					in = new BufferedInputStream(new FileInputStream(configIni));
//					ciProps.load(in);
//					profileId = ciProps.getProperty(PROP_P2_PROFILE);
//				} catch (IOException e) {
//					// Ignore
//				} finally {
//					if (in != null)
//						try {
//							in.close();
//						} catch (IOException e) {
//							// Ignore;
//						}
//				}
//				if (profileId == null)
//					profileId = destination.toString();
//			}
//		}
//		if (profileId != null)
//			targetAgent.registerService(PROP_P2_PROFILE, profileId);
//		else
//			targetAgent.unregisterService(PROP_P2_PROFILE, null);
//
//		IDirector director = (IDirector) targetAgent.getService(IDirector.SERVICE_NAME);
//		if (director == null)
//			throw new ProvisionException(Messages.Missing_director);
//
//		planner = (IPlanner) targetAgent.getService(IPlanner.SERVICE_NAME);
//		if (planner == null)
//			throw new ProvisionException(Messages.Missing_planner);
//
//		engine = (IEngine) targetAgent.getService(IEngine.SERVICE_NAME);
//		if (engine == null)
//			throw new ProvisionException(Messages.Missing_Engine);
//
//		targetAgent.registerService(UIServices.SERVICE_NAME, new AvoidTrustPromptService());
//	}	
	public static BundleContext getBundleContext() {
		return Platform.getBundle("org.simantics.project").getBundleContext();
	}
	
	public static IProvisioningAgentProvider getProvisioningAgentProvider() {
		BundleContext context = getBundleContext();		
		IProvisioningAgentProvider provider = (IProvisioningAgentProvider) getService(context, IProvisioningAgentProvider.SERVICE_NAME);
		if (provider==null) {
			DefaultAgentProvider p = new DefaultAgentProvider();
			p.activate(context);
			provider = p;
		}
		return provider;		
	}
	
	/**
	 * Create an provisioning agent.
	 * 
	 * @param agentLocation
	 * @return
	 * @throws ProvisionException 
	 */
	public static IProvisioningAgent createAgent(IPath agentLocation) throws ProvisionException {
		// Create recruiter
		IProvisioningAgentProvider provider = getProvisioningAgentProvider();

		// Recruit Agent - Permission to provision
		IProvisioningAgent agent = provider.createAgent(agentLocation == null ? null : agentLocation.toFile().toURI());
			
		// Omit "This bundle is not certified" dialog. 			
		UIServices serviceUI = new TrustAllCertificates();
		agent.registerService("org.eclipse.equinox.p2.core.UIServices", serviceUI);			
			
		return agent;
	}	
	
	
	/**
	 * Copied from ServiceHelper because we need to obtain services
	 * before p2 has been started.
	 */
	public static Object getService(BundleContext context, String name) {
		if (context == null)
			return null;
		ServiceReference reference = context.getServiceReference(name);
		if (reference == null)
			return null;
		Object result = context.getService(reference);
		context.ungetService(reference);
		return result;
	}	

}

