/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;

public class BundleInfo implements Comparable<BundleInfo>, IVersionedId {

	public static BundleInfo read(IInstallableUnit iu) {
    	String name = iu.getProperty("org.eclipse.equinox.p2.name");
    	String description = iu.getProperty("org.eclipse.equinox.p2.description");
    	return new BundleInfo(iu, name, description);
	}
	
	public IVersionedId vid;
	public String name;
	public String description;
	
	public BundleInfo(String id, String version, String name, String description) {
		vid = new VersionedId(id, version);
		this.name = name;
		this.description = description;
	}
	
	public BundleInfo(IVersionedId vid, String name, String description) {
		this.vid = vid;
		this.name = name;
		this.description = description;		 
	}

	@Override
	public String toString() {
		return name;
	}
	
	public String toVersionString() {		
		return Version.emptyVersion.equals(vid.getVersion()) ? vid.getId() : vid.getId() + '/' + vid.getVersion().toString();
	}
	
	@Override
	public int compareTo(BundleInfo o) {		
		return name.compareTo( o.name );
	}

	public String getId() {
		return vid.getId();
	}

	public void setId(IVersionedId vid) {
		this.vid = vid;
	}

	public Version getVersion() {
		return vid.getVersion();
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public int hashCode() {
		return vid.hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		return vid.equals(obj);
	}
	
}

