/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.internal;

import org.eclipse.core.runtime.Platform;

/**
 * Contains the active project framework -related debugging and tracing policy.
 * 
 * @author Tuukka Lehtonen
 */
public final class ProjectPolicy {

    // General debug flag for the plugin
    public static boolean DEBUG = false;

    public static boolean TRACE_PROJECT_MANAGEMENT = false;
    public static boolean TRACE_PROJECT_FEATURE_LOAD = false;

    static {
        if (Activator.getDefault().isDebugging()) {
            DEBUG = true;
            String sTrue = Boolean.TRUE.toString();

            TRACE_PROJECT_MANAGEMENT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/trace/projectManagement")); //$NON-NLS-1$
            TRACE_PROJECT_FEATURE_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/trace/projectFeatureLoad")); //$NON-NLS-1$
        }
    }

}
