/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.schema;

import java.util.ArrayList;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.structural.IStructuralObject;
import org.simantics.objmap.structural.StructuralResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLinkType
implements ILinkType<StructuralResource, IStructuralObject> {
    static Logger LOGGER = LoggerFactory.getLogger(SimpleLinkType.class);
    public Resource domainType;
    public Class<?> rangeType;
    ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>> rules;

    public SimpleLinkType(Resource domainType, Class<?> rangeType, ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>> rules) {
        this.domainType = domainType;
        this.rangeType = rangeType;
        this.rules = rules;
    }

    public SimpleLinkType(Resource domainType, Class<?> rangeType) {
        this(domainType, rangeType, new ArrayList<IBidirectionalMappingRule<StructuralResource, IStructuralObject>>());
    }

    public void addRule(IBidirectionalMappingRule<StructuralResource, IStructuralObject> rule) {
        this.rules.add(rule);
    }

    @Override
    public StructuralResource createDomainElement(WriteGraph g, IStructuralObject rangeElement) throws MappingException {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("SimpleLinkType.createDomainElement " + rangeElement.toString());
            }
            if (rangeElement.getContext().size() == 0) {
                Resource result = this.newResource(g, this.domainType);
                return new StructuralResource((ReadGraph)g, result, new Resource[0]);
            }
            if (rangeElement.getContext().size() == 1 && rangeElement.getContext().get(0).equals(rangeElement)) {
                Resource type = rangeElement.getType();
                Resource result = this.newResource(g, type);
                return new StructuralResource((ReadGraph)g, result, result);
            }
            throw new MappingException("Cannot create a new StucturalObject " + rangeElement + " " + rangeElement.getClass());
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    protected Resource newResource(WriteGraph g, Resource type) throws DatabaseException {
        Resource result = g.newResource();
        g.claim(result, Layer0.getInstance((ReadGraph)g).InstanceOf, null, type);
        return result;
    }

    @Override
    public IStructuralObject createRangeElement(ReadGraph g, StructuralResource domainElement) throws MappingException {
        try {
            if (LOGGER.isTraceEnabled()) {
                try {
                    LOGGER.trace("SimpleLinkType.createRangeElement " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement.getResource()));
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            IStructuralObject result = (IStructuralObject)this.rangeType.newInstance();
            if (domainElement.getContext().size() == 1 && domainElement.getContext().get(0).equals(domainElement.getResource())) {
                result.setContext(Collections.singletonList(result));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public void createDomain(WriteGraph graph, IBackwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        if (domainElement.isStructuralRoot()) {
            this.updateRange((ReadGraph)graph, (IForwardMapping<StructuralResource, IStructuralObject>)((IForwardMapping)((Object)mapping)), domainElement, rangeElement);
        }
        this.updateDomain(graph, mapping, domainElement, rangeElement);
    }

    @Override
    public void createRange(ReadGraph graph, IForwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        if (rangeElement.getContext().size() == 0 && domainElement.getContext().size() > 0) {
            ArrayList<IStructuralObject> ctx = new ArrayList<IStructuralObject>(domainElement.getContext().size());
            try {
                ArrayList<Resource> context = new ArrayList<Resource>();
                int i = 0;
                while (i < domainElement.getContext().size()) {
                    context.add(domainElement.getContext().get(i));
                    IStructuralObject ctxObj = mapping.get(new StructuralResource(graph, (Resource)context.get(context.size() - 1), context));
                    if (ctxObj == null) {
                        throw new MappingException("Cannot resolve range context for domain element " + domainElement);
                    }
                    ctx.add(ctxObj);
                    ++i;
                }
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
            if (ctx.size() == 0) {
                throw new MappingException("Cannot find context for structural object, " + domainElement);
            }
            rangeElement.setContext(ctx);
        }
        this.updateRange(graph, mapping, domainElement, rangeElement);
    }

    @Override
    public boolean checkChanges(ReadGraph g, IForwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        boolean updated = false;
        for (IBidirectionalMappingRule<StructuralResource, IStructuralObject> rule : this.rules) {
            updated |= rule.checkChanges(g, map, domainElement, rangeElement);
        }
        return updated;
    }

    @Override
    public boolean updateDomain(WriteGraph g, IBackwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            try {
                LOGGER.trace("SimpleLinkType.updateDomain " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement.getResource()) + " " + rangeElement.toString());
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        boolean updated = false;
        for (IBidirectionalMappingRule<StructuralResource, IStructuralObject> rule : this.rules) {
            updated |= rule.updateDomain(g, map, domainElement, rangeElement);
        }
        return updated;
    }

    @Override
    public boolean updateRange(ReadGraph g, IForwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            try {
                LOGGER.trace("SimpleLinkType.updateRange " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement.getResource()) + " " + rangeElement.toString());
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        boolean updated = false;
        for (IBidirectionalMappingRule<StructuralResource, IStructuralObject> rule : this.rules) {
            updated |= rule.updateRange(g, map, domainElement, rangeElement);
        }
        return updated;
    }
}

