/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.rules.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.graph.rules.domain.MappingUtils;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.rules.domain.StructuralUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuralRelatedObjectsAccessor
implements IDomainAccessor<StructuralResource, Collection<StructuralResource>> {
    static Logger LOGGER = LoggerFactory.getLogger(StructuralRelatedObjectsAccessor.class);
    Resource relation;
    boolean deleteExtraObjects;

    public StructuralRelatedObjectsAccessor(Resource relation, boolean deleteExtraObjects) {
        this.relation = relation;
        this.deleteExtraObjects = deleteExtraObjects;
    }

    @Override
    public Collection<StructuralResource> get(ReadGraph g, StructuralResource element) throws MappingException {
        try {
            LOGGER.trace("        RelatedObjectsAccessor.get");
            if (!element.isStructural()) {
                return Collections.emptyList();
            }
            Resource instance = StructuralUtils.getContainingInstance(element);
            Resource publicRelation = StructuralUtils.getPublishedRelation(g, element, this.relation);
            if (publicRelation == null) {
                return Collections.emptyList();
            }
            Collection coll = g.getObjects(instance, publicRelation);
            ArrayList<StructuralResource> result = new ArrayList<StructuralResource>(coll.size());
            ArrayList<Resource> context = new ArrayList<Resource>();
            int i = 0;
            while (i < element.getContext().size() - 1) {
                context.add(element.getContext().get(i));
                ++i;
            }
            for (Resource r : coll) {
                if (StructuralUtils.isStructuralInstance(g, r)) {
                    result.add(new StructuralResource(g, r, context, r));
                    continue;
                }
                result.add(new StructuralResource(g, r, context));
            }
            return result;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean set(WriteGraph g, StructuralResource element, Collection<StructuralResource> value) throws MappingException {
        try {
            LOGGER.trace("        RelatedObjectsAccessor.set");
            if (!element.isStructural()) {
                return false;
            }
            Resource instance = StructuralUtils.getContainingInstance(element);
            Resource publicRelation = null;
            if (value.size() == 0) {
                publicRelation = StructuralUtils.getPublishedRelation((ReadGraph)g, element, this.relation);
                if (publicRelation == null) {
                    return false;
                }
                return MappingUtils.synchronizeStatements(g, instance, publicRelation, new Resource[0], this.deleteExtraObjects);
            }
            publicRelation = StructuralUtils.getOrCreatePublishedRelation(g, element, this.relation);
            if (publicRelation == null) {
                throw new MappingException("Structural Resource " + element + " cannot contain structural elements, the Resource is not published.");
            }
            Resource[] arr = new Resource[value.size()];
            int i = 0;
            Iterator<StructuralResource> iterator = value.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return MappingUtils.synchronizeStatements(g, instance, publicRelation, arr, this.deleteExtraObjects);
                }
                StructuralResource sr = iterator.next();
                arr[i++] = sr.getResource();
            }
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }
}

