/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.schema;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.schema.ILinkType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLinkType<Range>
implements ILinkType<Resource, Range> {
    static Logger LOGGER = LoggerFactory.getLogger(SimpleLinkType.class);
    public Resource domainType;
    public Class<?> rangeType;
    ArrayList<IBidirectionalMappingRule<Resource, Range>> rules;

    public SimpleLinkType(Resource domainType, Class<?> rangeType, ArrayList<IBidirectionalMappingRule<Resource, Range>> rules) {
        this.domainType = domainType;
        this.rangeType = rangeType;
        this.rules = rules;
    }

    public SimpleLinkType(Resource domainType, Class<?> rangeType) {
        this(domainType, rangeType, new ArrayList<IBidirectionalMappingRule<Resource, Range>>());
    }

    public void addRule(IBidirectionalMappingRule<Resource, Range> rule) {
        this.rules.add(rule);
    }

    @Override
    public Resource createDomainElement(WriteGraph g, Range rangeElement) throws MappingException {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("SimpleLinkType.createDomainElement " + rangeElement.toString());
            }
            Resource result = g.newResource();
            g.claim(result, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.domainType);
            return result;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public Range createRangeElement(ReadGraph g, Resource domainElement) throws MappingException {
        try {
            if (LOGGER.isTraceEnabled()) {
                try {
                    LOGGER.trace("SimpleLinkType.createRangeElement " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement));
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            return (Range)this.rangeType.newInstance();
        }
        catch (InstantiationException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public void createDomain(WriteGraph graph, IBackwardMapping<Resource, Range> mapping, Resource domainElement, Range rangeElement) throws MappingException {
        this.updateDomain(graph, mapping, domainElement, rangeElement);
    }

    @Override
    public void createRange(ReadGraph graph, IForwardMapping<Resource, Range> mapping, Resource domainElement, Range rangeElement) throws MappingException {
        this.updateRange(graph, mapping, domainElement, rangeElement);
    }

    @Override
    public boolean checkChanges(ReadGraph g, IForwardMapping<Resource, Range> map, Resource domainElement, Range rangeElement) throws MappingException {
        boolean updated = false;
        for (IBidirectionalMappingRule<Resource, Range> rule : this.rules) {
            updated |= rule.checkChanges(g, map, domainElement, rangeElement);
        }
        return updated;
    }

    @Override
    public boolean updateDomain(WriteGraph g, IBackwardMapping<Resource, Range> map, Resource domainElement, Range rangeElement) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            try {
                LOGGER.trace("SimpleLinkType.updateDomain " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement) + " " + rangeElement.toString());
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        boolean updated = false;
        for (IBidirectionalMappingRule<Resource, Range> rule : this.rules) {
            updated |= rule.updateDomain(g, map, domainElement, rangeElement);
        }
        return updated;
    }

    @Override
    public boolean updateRange(ReadGraph g, IForwardMapping<Resource, Range> map, Resource domainElement, Range rangeElement) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            try {
                LOGGER.trace("SimpleLinkType.updateRange " + NameUtils.getSafeName((ReadGraph)g, (Resource)domainElement) + " " + rangeElement.getClass().getName() + "@" + Integer.toHexString(rangeElement.hashCode()));
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        boolean updated = false;
        for (IBidirectionalMappingRule<Resource, Range> rule : this.rules) {
            updated |= rule.updateRange(g, map, domainElement, rangeElement);
        }
        return updated;
    }
}

