/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.schema;

import gnu.trove.map.hash.THashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.schema.AdaptedLinkType;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.objmap.graph.schema.SimpleLinkType;

public class DefaultSchema
implements IMappingSchema<Resource, Object> {
    THashMap<Resource, ILinkType<Resource, Object>> domainLinkTypes = new THashMap();
    THashMap<Class<?>, ILinkType<Resource, Object>> rangeLinkTypes = new THashMap();

    public void addLinkType(SimpleLinkType<Object> linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, linkType);
        this.rangeLinkTypes.put(linkType.rangeType, linkType);
    }

    public void addLinkType(AdaptedLinkType<Object> linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, linkType);
        this.rangeLinkTypes.put(linkType.rangeType, linkType);
    }

    @Override
    public ILinkType<Resource, Object> linkTypeOfDomainElement(ReadGraph g, Resource element) throws MappingException {
        try {
            for (Resource type : g.getTypes(element)) {
                ILinkType linkType = (ILinkType)this.domainLinkTypes.get((Object)type);
                if (linkType == null) continue;
                return linkType;
            }
            throw new MappingException("Didn't find a link type for " + NameUtils.getSafeName((ReadGraph)g, (Resource)element) + ".");
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public ILinkType<Resource, Object> linkTypeOfRangeElement(Object element) throws MappingException {
        ILinkType type = (ILinkType)this.rangeLinkTypes.get(element.getClass());
        if (type == null) {
            Class<?>[] classArray = element.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                type = (ILinkType)this.rangeLinkTypes.get(clazz);
                if (type != null) {
                    return type;
                }
                ++n2;
            }
            throw new MappingException("Didn't find a link type for " + element + ".");
        }
        return type;
    }

    public ILinkType<Resource, Object> linkTypeOfDomainType(ReadGraph g, Resource type) {
        return (ILinkType)this.domainLinkTypes.get((Object)type);
    }

    public ILinkType<Resource, Object> linkTypeOfRangeType(Class<?> clazz) {
        ILinkType type = (ILinkType)this.rangeLinkTypes.get(clazz);
        if (type == null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                type = (ILinkType)this.rangeLinkTypes.get(clazz);
                if (type != null) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }
}

