/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;

public class CollectionAccessor<Range, T>
implements IRangeAccessor<Range, Collection<T>> {
    private Method getter;
    private Method adder;
    private Method remover;

    public CollectionAccessor(Method getter, Method adder, Method remover) {
        this.getter = getter;
        this.adder = adder;
        this.remover = remover;
    }

    @Override
    public Collection<T> get(Object element) throws MappingException {
        try {
            return (Collection)this.getter.invoke(element, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
    }

    @Override
    public boolean set(Range element, Collection<T> value) throws MappingException {
        Object current = this.get((Object)element);
        ArrayList adding = new ArrayList();
        ArrayList removing = new ArrayList();
        Iterator<Object> iterator = current.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (value.contains(e)) continue;
            removing.add(e);
        }
        for (Object e : value) {
            if (current.contains(e)) continue;
            adding.add(e);
        }
        try {
            for (Object e : removing) {
                this.remover.invoke(element, e);
            }
            for (Object e : adding) {
                this.adder.invoke(element, e);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
        return removing.size() > 0 || adding.size() > 0;
    }
}

