/*******************************************************************************
 * Copyright (c) 2016, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal;

import org.simantics.nativemem.ProcessMemoryInfo;

/**
 * @author Tuukka Lehtonen
 */
public enum DummyProcessMemoryInfo implements ProcessMemoryInfo {
	INSTANCE;

	@Override
	public String toHumanReadableString() {
		return "Native process memory consumption information not available for this platform (" + OS.calculate() + "; " + Arch.calculate() + ")";
	}

	@Override
	public String headerRow() {
		return "";
	}

	@Override
	public String dataRow() {
		return "";
	}

}
