/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals.rules;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;

public enum InstanceOfRule implements ITypicalSynchronizationRule
{
    INSTANCE;


    public static InstanceOfRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
        boolean changed = false;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection templateInstanceOf = graph.getObjects(template, L0.InstanceOf);
        Collection instanceInstanceOf = graph.getObjects(instance, L0.InstanceOf);
        for (Resource instanceOf : templateInstanceOf) {
            if (graph.hasStatement(instance, L0.InstanceOf, instanceOf)) continue;
            graph.claim(instance, L0.InstanceOf, instanceOf);
            info.messageLog.add("\t\t\tadd type  " + NameUtils.getSafeName((ReadGraph)graph, (Resource)instanceOf));
            changed = true;
        }
        for (Resource instanceOf : instanceInstanceOf) {
            if (templateInstanceOf.contains(instanceOf) || !graph.hasStatement(instance, L0.InstanceOf, instanceOf)) continue;
            graph.deny(instance, L0.InstanceOf, instanceOf);
            info.messageLog.add("\t\t\tremove type " + NameUtils.getSafeName((ReadGraph)graph, (Resource)instanceOf));
            changed = true;
        }
        return changed;
    }
}

