/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.MultiStatus;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.Pair;

public class CollectSubscriptions
extends ResourceRead<SubscriptionCollectionResult> {
    private static final boolean PERF = false;
    private static final boolean DEBUG = false;
    protected Resource experiment;
    protected double defaultSamplingInterval;
    protected boolean synchronous;

    public CollectSubscriptions(IDynamicExperiment experiment, double defaultSamplingInterval) {
        this(experiment.getModel(), experiment.getResource(), defaultSamplingInterval, false);
    }

    public CollectSubscriptions(IDynamicExperiment experiment, double defaultSamplingInterval, boolean synchronous) {
        this(experiment.getModel(), experiment.getResource(), defaultSamplingInterval, synchronous);
    }

    public CollectSubscriptions(Resource model, Resource experiment, double defaultSamplingInterval) {
        this(model, experiment, defaultSamplingInterval, false);
    }

    public CollectSubscriptions(Resource model, Resource experiment, double defaultSamplingInterval, boolean synchronous) {
        super(model);
        this.experiment = experiment;
        this.defaultSamplingInterval = defaultSamplingInterval;
    }

    public SubscriptionCollectionResult perform(ReadGraph graph) throws DatabaseException {
        MultiStatus status = new MultiStatus("org.simantics.modeling", 0, "History collection subscription resolution problems:", null);
        boolean oldSync = graph.setSynchronous(this.synchronous);
        try {
            Map<String, SubscriptionItem> items = this.gatherSubscriptions(graph, this.resource, status, new TreeMap<String, SubscriptionItem>());
            SubscriptionCollectionResult subscriptionCollectionResult = new SubscriptionCollectionResult(new ArrayList<SubscriptionItem>(items.values()), status);
            return subscriptionCollectionResult;
        }
        finally {
            graph.setSynchronous(oldSync);
        }
    }

    public Map<String, SubscriptionItem> gatherSubscriptions(ReadGraph graph, Resource model, MultiStatus status, Map<String, SubscriptionItem> items) throws DatabaseException {
        long start = System.nanoTime();
        Variable configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)model);
        if (configuration == null) {
            return items;
        }
        Variable experimentVariable = null;
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource run : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.experiment, L0.ConsistsOf, SIMU.Run))) {
            if (!graph.hasStatement(run, SIMU.IsActive)) continue;
            try {
                experimentVariable = Variables.switchRealization((ReadGraph)graph, (Variable)configuration, (Resource)run);
            }
            catch (DatabaseException databaseException) {
                experimentVariable = Variables.switchPossibleContext((ReadGraph)graph, (Variable)configuration, (Resource)run);
            }
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Param constants = new Param(configuration, experimentVariable, this.defaultSamplingInterval);
        for (Resource subscription : (Collection)graph.syncRequest((Read)new ObjectsWithType(model, L0.ConsistsOf, MOD.Subscription))) {
            Map subscriptionItems = (Map)graph.syncRequest((Read)new SubscriptionRequest(subscription, constants), (AsyncProcedure)TransientCacheAsyncListener.instance());
            items.putAll(subscriptionItems);
        }
        return items;
    }

    static class ItemRequest
    extends TernaryRead<Resource, String, Param, SubscriptionItem> {
        public ItemRequest(Resource item, String groupId, Param constants) {
            super((Object)item, (Object)groupId, (Object)constants);
        }

        public SubscriptionItem perform(ReadGraph graph) throws DatabaseException {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource subscriptionItem = (Resource)this.parameter;
            String groupId = (String)this.parameter2;
            Param constants = (Param)((Object)this.parameter3);
            Variable configurationContext = (Variable)constants.c0;
            Variable experimentContext = (Variable)constants.c1;
            double defaultSamplingInterval = (Double)constants.c2;
            Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
            RVI rvi = (RVI)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding);
            if (rvi == null) {
                return null;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String guid = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasName);
            if (guid == null) {
                return null;
            }
            String variablePersistentId = rvi.toString();
            Pair variable = Variables.resolvePossible((ReadGraph)graph, (RVI)rvi, (Variable)configurationContext, (Variable)experimentContext);
            if (variable == null) {
                return null;
            }
            String variableId = rvi.asPossibleString(graph, (Variable)variable.second);
            if (variableId == null) {
                return null;
            }
            Datatype type = (Datatype)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Datatype, Bindings.getBindingUnchecked(Datatype.class));
            if (type == null && variable != null) {
                type = ((Variable)variable.first).getPossibleDatatype(graph);
            }
            if (type == null) {
                return null;
            }
            Double itemSamplingInterval = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_SamplingInterval, (Binding)Bindings.DOUBLE);
            Double itemDeadband = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Deadband, (Binding)Bindings.DOUBLE);
            Double bias = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Bias, (Binding)Bindings.DOUBLE);
            Double gain = (Double)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Gain, (Binding)Bindings.DOUBLE);
            String unit = (String)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
            double samplingInterval = itemSamplingInterval != null ? itemSamplingInterval : defaultSamplingInterval;
            double deadband = itemDeadband != null ? itemDeadband : 0.0;
            SubscriptionItem item = new SubscriptionItem();
            item.id = guid;
            item.variableId = variableId;
            item.groupId = groupId;
            item.groupItemId = variablePersistentId;
            item.format = type;
            item.formatId = unit == null ? "" : unit;
            item.deadband = deadband;
            item.interval = samplingInterval;
            if (bias != null) {
                item.bias = bias;
            }
            if (gain != null) {
                item.gain = gain;
            }
            return item;
        }
    }

    static class Param
    extends Tuple3 {
        public Param(Variable configurationContext, Variable experimentContext, Double defaultSamplingInterval) {
            super((Object)configurationContext, (Object)experimentContext, (Object)defaultSamplingInterval);
        }
    }

    static class SubscriptionItemsRequest
    extends TernaryRead<Resource, String, Param, Map<String, SubscriptionItem>> {
        public SubscriptionItemsRequest(Resource subscription, String groupId, Param constants) {
            super((Object)subscription, (Object)groupId, (Object)constants);
        }

        public Map<String, SubscriptionItem> perform(ReadGraph graph) throws DatabaseException {
            long start = System.nanoTime();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Collection subscriptionItems = (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, MOD.Subscription_Item));
            if (subscriptionItems.isEmpty()) {
                return Collections.emptyMap();
            }
            THashMap result = new THashMap(subscriptionItems.size());
            for (Resource subscriptionItem : subscriptionItems) {
                SubscriptionItem hi = (SubscriptionItem)graph.syncRequest((Read)new ItemRequest(subscriptionItem, (String)this.parameter2, (Param)((Object)this.parameter3)), (Listener)TransientCacheListener.instance());
                if (hi == null) continue;
                result.put(hi.id, hi);
            }
            return result;
        }
    }

    static class SubscriptionRequest
    extends BinaryRead<Resource, Param, Map<String, SubscriptionItem>> {
        public SubscriptionRequest(Resource subscription, Param constants) {
            super((Object)subscription, (Object)constants);
        }

        public Map<String, SubscriptionItem> perform(ReadGraph graph) throws DatabaseException {
            long start = System.nanoTime();
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Boolean v = (Boolean)graph.getPossibleRelatedValue((Resource)this.parameter, MOD.Subscription_Enabled, (Binding)Bindings.BOOLEAN);
            if (!Boolean.TRUE.equals(v)) {
                return Collections.emptyMap();
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String groupId = (String)graph.getPossibleRelatedValue((Resource)this.parameter, L0.HasName, (Binding)Bindings.STRING);
            if (groupId == null) {
                return Collections.emptyMap();
            }
            Map items = (Map)graph.syncRequest((Read)new SubscriptionItemsRequest((Resource)this.parameter, groupId, (Param)((Object)this.parameter2)), (AsyncProcedure)TransientCacheAsyncListener.instance());
            return items;
        }
    }
}

